/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.alexaforbusiness.transform.SortMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a sort criteria.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Sort implements StructuredPojo, ToCopyableBuilder<Sort.Builder, Sort> {
    private final String key;

    private final String value;

    private Sort(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
    }

    /**
     * <p>
     * The sort key of a sort object.
     * </p>
     * 
     * @return The sort key of a sort object.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The sort value of a sort object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #value} will return
     * {@link SortValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #valueString}.
     * </p>
     * 
     * @return The sort value of a sort object.
     * @see SortValue
     */
    public SortValue value() {
        return SortValue.fromValue(value);
    }

    /**
     * <p>
     * The sort value of a sort object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #value} will return
     * {@link SortValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #valueString}.
     * </p>
     * 
     * @return The sort value of a sort object.
     * @see SortValue
     */
    public String valueString() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(valueString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sort)) {
            return false;
        }
        Sort other = (Sort) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(valueString(), other.valueString());
    }

    @Override
    public String toString() {
        return ToString.builder("Sort").add("Key", key()).add("Value", valueString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.of(clazz.cast(key()));
        case "Value":
            return Optional.of(clazz.cast(valueString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SortMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Sort> {
        /**
         * <p>
         * The sort key of a sort object.
         * </p>
         * 
         * @param key
         *        The sort key of a sort object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The sort value of a sort object.
         * </p>
         * 
         * @param value
         *        The sort value of a sort object.
         * @see SortValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortValue
         */
        Builder value(String value);

        /**
         * <p>
         * The sort value of a sort object.
         * </p>
         * 
         * @param value
         *        The sort value of a sort object.
         * @see SortValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortValue
         */
        Builder value(SortValue value);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Sort model) {
            key(model.key);
            value(model.value);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public final Builder value(SortValue value) {
            this.value(value.toString());
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public Sort build() {
            return new Sort(this);
        }
    }
}
