/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateDeviceRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<UpdateDeviceRequest.Builder, UpdateDeviceRequest> {
    private final String deviceArn;

    private final String deviceName;

    private UpdateDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.deviceArn = builder.deviceArn;
        this.deviceName = builder.deviceName;
    }

    /**
     * <p>
     * The ARN of the device to update. Required.
     * </p>
     * 
     * @return The ARN of the device to update. Required.
     */
    public String deviceArn() {
        return deviceArn;
    }

    /**
     * <p>
     * The updated device name. Required.
     * </p>
     * 
     * @return The updated device name. Required.
     */
    public String deviceName() {
        return deviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeviceRequest)) {
            return false;
        }
        UpdateDeviceRequest other = (UpdateDeviceRequest) obj;
        return Objects.equals(deviceArn(), other.deviceArn()) && Objects.equals(deviceName(), other.deviceName());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateDeviceRequest").add("DeviceArn", deviceArn()).add("DeviceName", deviceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceArn":
            return Optional.of(clazz.cast(deviceArn()));
        case "DeviceName":
            return Optional.of(clazz.cast(deviceName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, CopyableBuilder<Builder, UpdateDeviceRequest> {
        /**
         * <p>
         * The ARN of the device to update. Required.
         * </p>
         * 
         * @param deviceArn
         *        The ARN of the device to update. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * The updated device name. Required.
         * </p>
         * 
         * @param deviceName
         *        The updated device name. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String deviceArn;

        private String deviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeviceRequest model) {
            deviceArn(model.deviceArn);
            deviceName(model.deviceName);
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateDeviceRequest build() {
            return new UpdateDeviceRequest(this);
        }
    }
}
