/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateProfileRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<UpdateProfileRequest.Builder, UpdateProfileRequest> {
    private final String profileArn;

    private final String profileName;

    private final String timezone;

    private final String address;

    private final String distanceUnit;

    private final String temperatureUnit;

    private final String wakeWord;

    private final Boolean setupModeDisabled;

    private final Integer maxVolumeLimit;

    private final Boolean pstnEnabled;

    private UpdateProfileRequest(BuilderImpl builder) {
        super(builder);
        this.profileArn = builder.profileArn;
        this.profileName = builder.profileName;
        this.timezone = builder.timezone;
        this.address = builder.address;
        this.distanceUnit = builder.distanceUnit;
        this.temperatureUnit = builder.temperatureUnit;
        this.wakeWord = builder.wakeWord;
        this.setupModeDisabled = builder.setupModeDisabled;
        this.maxVolumeLimit = builder.maxVolumeLimit;
        this.pstnEnabled = builder.pstnEnabled;
    }

    /**
     * <p>
     * The ARN of the room profile to update. Required.
     * </p>
     * 
     * @return The ARN of the room profile to update. Required.
     */
    public String profileArn() {
        return profileArn;
    }

    /**
     * <p>
     * The updated name for the room profile.
     * </p>
     * 
     * @return The updated name for the room profile.
     */
    public String profileName() {
        return profileName;
    }

    /**
     * <p>
     * The updated timezone for the room profile.
     * </p>
     * 
     * @return The updated timezone for the room profile.
     */
    public String timezone() {
        return timezone;
    }

    /**
     * <p>
     * The updated address for the room profile.
     * </p>
     * 
     * @return The updated address for the room profile.
     */
    public String address() {
        return address;
    }

    /**
     * <p>
     * The updated distance unit for the room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceUnit} will
     * return {@link DistanceUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distanceUnitString}.
     * </p>
     * 
     * @return The updated distance unit for the room profile.
     * @see DistanceUnit
     */
    public DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(distanceUnit);
    }

    /**
     * <p>
     * The updated distance unit for the room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceUnit} will
     * return {@link DistanceUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distanceUnitString}.
     * </p>
     * 
     * @return The updated distance unit for the room profile.
     * @see DistanceUnit
     */
    public String distanceUnitString() {
        return distanceUnit;
    }

    /**
     * <p>
     * The updated temperature unit for the room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #temperatureUnit}
     * will return {@link TemperatureUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #temperatureUnitString}.
     * </p>
     * 
     * @return The updated temperature unit for the room profile.
     * @see TemperatureUnit
     */
    public TemperatureUnit temperatureUnit() {
        return TemperatureUnit.fromValue(temperatureUnit);
    }

    /**
     * <p>
     * The updated temperature unit for the room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #temperatureUnit}
     * will return {@link TemperatureUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #temperatureUnitString}.
     * </p>
     * 
     * @return The updated temperature unit for the room profile.
     * @see TemperatureUnit
     */
    public String temperatureUnitString() {
        return temperatureUnit;
    }

    /**
     * <p>
     * The updated wake word for the room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wakeWord} will
     * return {@link WakeWord#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #wakeWordString}.
     * </p>
     * 
     * @return The updated wake word for the room profile.
     * @see WakeWord
     */
    public WakeWord wakeWord() {
        return WakeWord.fromValue(wakeWord);
    }

    /**
     * <p>
     * The updated wake word for the room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wakeWord} will
     * return {@link WakeWord#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #wakeWordString}.
     * </p>
     * 
     * @return The updated wake word for the room profile.
     * @see WakeWord
     */
    public String wakeWordString() {
        return wakeWord;
    }

    /**
     * <p>
     * Whether the setup mode of the profile is enabled.
     * </p>
     * 
     * @return Whether the setup mode of the profile is enabled.
     */
    public Boolean setupModeDisabled() {
        return setupModeDisabled;
    }

    /**
     * <p>
     * The updated maximum volume limit for the room profile.
     * </p>
     * 
     * @return The updated maximum volume limit for the room profile.
     */
    public Integer maxVolumeLimit() {
        return maxVolumeLimit;
    }

    /**
     * <p>
     * Whether the PSTN setting of the room profile is enabled.
     * </p>
     * 
     * @return Whether the PSTN setting of the room profile is enabled.
     */
    public Boolean pstnEnabled() {
        return pstnEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(profileName());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(distanceUnitString());
        hashCode = 31 * hashCode + Objects.hashCode(temperatureUnitString());
        hashCode = 31 * hashCode + Objects.hashCode(wakeWordString());
        hashCode = 31 * hashCode + Objects.hashCode(setupModeDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(maxVolumeLimit());
        hashCode = 31 * hashCode + Objects.hashCode(pstnEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProfileRequest)) {
            return false;
        }
        UpdateProfileRequest other = (UpdateProfileRequest) obj;
        return Objects.equals(profileArn(), other.profileArn()) && Objects.equals(profileName(), other.profileName())
                && Objects.equals(timezone(), other.timezone()) && Objects.equals(address(), other.address())
                && Objects.equals(distanceUnitString(), other.distanceUnitString())
                && Objects.equals(temperatureUnitString(), other.temperatureUnitString())
                && Objects.equals(wakeWordString(), other.wakeWordString())
                && Objects.equals(setupModeDisabled(), other.setupModeDisabled())
                && Objects.equals(maxVolumeLimit(), other.maxVolumeLimit()) && Objects.equals(pstnEnabled(), other.pstnEnabled());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateProfileRequest").add("ProfileArn", profileArn()).add("ProfileName", profileName())
                .add("Timezone", timezone()).add("Address", address()).add("DistanceUnit", distanceUnitString())
                .add("TemperatureUnit", temperatureUnitString()).add("WakeWord", wakeWordString())
                .add("SetupModeDisabled", setupModeDisabled()).add("MaxVolumeLimit", maxVolumeLimit())
                .add("PSTNEnabled", pstnEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileArn":
            return Optional.of(clazz.cast(profileArn()));
        case "ProfileName":
            return Optional.of(clazz.cast(profileName()));
        case "Timezone":
            return Optional.of(clazz.cast(timezone()));
        case "Address":
            return Optional.of(clazz.cast(address()));
        case "DistanceUnit":
            return Optional.of(clazz.cast(distanceUnitString()));
        case "TemperatureUnit":
            return Optional.of(clazz.cast(temperatureUnitString()));
        case "WakeWord":
            return Optional.of(clazz.cast(wakeWordString()));
        case "SetupModeDisabled":
            return Optional.of(clazz.cast(setupModeDisabled()));
        case "MaxVolumeLimit":
            return Optional.of(clazz.cast(maxVolumeLimit()));
        case "PSTNEnabled":
            return Optional.of(clazz.cast(pstnEnabled()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, CopyableBuilder<Builder, UpdateProfileRequest> {
        /**
         * <p>
         * The ARN of the room profile to update. Required.
         * </p>
         * 
         * @param profileArn
         *        The ARN of the room profile to update. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileArn(String profileArn);

        /**
         * <p>
         * The updated name for the room profile.
         * </p>
         * 
         * @param profileName
         *        The updated name for the room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileName(String profileName);

        /**
         * <p>
         * The updated timezone for the room profile.
         * </p>
         * 
         * @param timezone
         *        The updated timezone for the room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * The updated address for the room profile.
         * </p>
         * 
         * @param address
         *        The updated address for the room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);

        /**
         * <p>
         * The updated distance unit for the room profile.
         * </p>
         * 
         * @param distanceUnit
         *        The updated distance unit for the room profile.
         * @see DistanceUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceUnit
         */
        Builder distanceUnit(String distanceUnit);

        /**
         * <p>
         * The updated distance unit for the room profile.
         * </p>
         * 
         * @param distanceUnit
         *        The updated distance unit for the room profile.
         * @see DistanceUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceUnit
         */
        Builder distanceUnit(DistanceUnit distanceUnit);

        /**
         * <p>
         * The updated temperature unit for the room profile.
         * </p>
         * 
         * @param temperatureUnit
         *        The updated temperature unit for the room profile.
         * @see TemperatureUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemperatureUnit
         */
        Builder temperatureUnit(String temperatureUnit);

        /**
         * <p>
         * The updated temperature unit for the room profile.
         * </p>
         * 
         * @param temperatureUnit
         *        The updated temperature unit for the room profile.
         * @see TemperatureUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemperatureUnit
         */
        Builder temperatureUnit(TemperatureUnit temperatureUnit);

        /**
         * <p>
         * The updated wake word for the room profile.
         * </p>
         * 
         * @param wakeWord
         *        The updated wake word for the room profile.
         * @see WakeWord
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WakeWord
         */
        Builder wakeWord(String wakeWord);

        /**
         * <p>
         * The updated wake word for the room profile.
         * </p>
         * 
         * @param wakeWord
         *        The updated wake word for the room profile.
         * @see WakeWord
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WakeWord
         */
        Builder wakeWord(WakeWord wakeWord);

        /**
         * <p>
         * Whether the setup mode of the profile is enabled.
         * </p>
         * 
         * @param setupModeDisabled
         *        Whether the setup mode of the profile is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setupModeDisabled(Boolean setupModeDisabled);

        /**
         * <p>
         * The updated maximum volume limit for the room profile.
         * </p>
         * 
         * @param maxVolumeLimit
         *        The updated maximum volume limit for the room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxVolumeLimit(Integer maxVolumeLimit);

        /**
         * <p>
         * Whether the PSTN setting of the room profile is enabled.
         * </p>
         * 
         * @param pstnEnabled
         *        Whether the PSTN setting of the room profile is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pstnEnabled(Boolean pstnEnabled);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String profileArn;

        private String profileName;

        private String timezone;

        private String address;

        private String distanceUnit;

        private String temperatureUnit;

        private String wakeWord;

        private Boolean setupModeDisabled;

        private Integer maxVolumeLimit;

        private Boolean pstnEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProfileRequest model) {
            profileArn(model.profileArn);
            profileName(model.profileName);
            timezone(model.timezone);
            address(model.address);
            distanceUnit(model.distanceUnit);
            temperatureUnit(model.temperatureUnit);
            wakeWord(model.wakeWord);
            setupModeDisabled(model.setupModeDisabled);
            maxVolumeLimit(model.maxVolumeLimit);
            pstnEnabled(model.pstnEnabled);
        }

        public final String getProfileArn() {
            return profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        public final String getProfileName() {
            return profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        public final String getTimezone() {
            return timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public final String getAddress() {
            return address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final String getDistanceUnit() {
            return distanceUnit;
        }

        @Override
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit.toString());
            return this;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        public final String getTemperatureUnit() {
            return temperatureUnit;
        }

        @Override
        public final Builder temperatureUnit(String temperatureUnit) {
            this.temperatureUnit = temperatureUnit;
            return this;
        }

        @Override
        public final Builder temperatureUnit(TemperatureUnit temperatureUnit) {
            this.temperatureUnit(temperatureUnit.toString());
            return this;
        }

        public final void setTemperatureUnit(String temperatureUnit) {
            this.temperatureUnit = temperatureUnit;
        }

        public final String getWakeWord() {
            return wakeWord;
        }

        @Override
        public final Builder wakeWord(String wakeWord) {
            this.wakeWord = wakeWord;
            return this;
        }

        @Override
        public final Builder wakeWord(WakeWord wakeWord) {
            this.wakeWord(wakeWord.toString());
            return this;
        }

        public final void setWakeWord(String wakeWord) {
            this.wakeWord = wakeWord;
        }

        public final Boolean getSetupModeDisabled() {
            return setupModeDisabled;
        }

        @Override
        public final Builder setupModeDisabled(Boolean setupModeDisabled) {
            this.setupModeDisabled = setupModeDisabled;
            return this;
        }

        public final void setSetupModeDisabled(Boolean setupModeDisabled) {
            this.setupModeDisabled = setupModeDisabled;
        }

        public final Integer getMaxVolumeLimit() {
            return maxVolumeLimit;
        }

        @Override
        public final Builder maxVolumeLimit(Integer maxVolumeLimit) {
            this.maxVolumeLimit = maxVolumeLimit;
            return this;
        }

        public final void setMaxVolumeLimit(Integer maxVolumeLimit) {
            this.maxVolumeLimit = maxVolumeLimit;
        }

        public final Boolean getPSTNEnabled() {
            return pstnEnabled;
        }

        @Override
        public final Builder pstnEnabled(Boolean pstnEnabled) {
            this.pstnEnabled = pstnEnabled;
            return this;
        }

        public final void setPSTNEnabled(Boolean pstnEnabled) {
            this.pstnEnabled = pstnEnabled;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateProfileRequest build() {
            return new UpdateProfileRequest(this);
        }
    }
}
