/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.alexaforbusiness.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GetRoomResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetRoomResponseUnmarshaller implements Unmarshaller<GetRoomResponse, JsonUnmarshallerContext> {

    public GetRoomResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetRoomResponse.Builder getRoomResponseBuilder = GetRoomResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return getRoomResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Room", targetDepth)) {
                    context.nextToken();
                    getRoomResponseBuilder.room(RoomUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return getRoomResponseBuilder.build();
    }

    private static final GetRoomResponseUnmarshaller INSTANCE = new GetRoomResponseUnmarshaller();

    public static GetRoomResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
