/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.model.RoomSkillParameter;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link RoomSkillParameter} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class RoomSkillParameterMarshaller {
    private static final MarshallingInfo<String> PARAMETERKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterKey").isBinary(false).build();

    private static final MarshallingInfo<String> PARAMETERVALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterValue").isBinary(false).build();

    private static final RoomSkillParameterMarshaller INSTANCE = new RoomSkillParameterMarshaller();

    private RoomSkillParameterMarshaller() {
    }

    public static RoomSkillParameterMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(RoomSkillParameter roomSkillParameter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(roomSkillParameter, "roomSkillParameter");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(roomSkillParameter.parameterKey(), PARAMETERKEY_BINDING);
            protocolMarshaller.marshall(roomSkillParameter.parameterValue(), PARAMETERVALUE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
