/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.EnrollmentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserData> {
    private static final SdkField<String> USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UserData.getter(UserData::userArn)).setter(UserData.setter(Builder::userArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserArn").build()}).build();
    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UserData.getter(UserData::firstName)).setter(UserData.setter(Builder::firstName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()}).build();
    private static final SdkField<String> LAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UserData.getter(UserData::lastName)).setter(UserData.setter(Builder::lastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UserData.getter(UserData::email)).setter(UserData.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()}).build();
    private static final SdkField<String> ENROLLMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UserData.getter(UserData::enrollmentStatusAsString)).setter(UserData.setter(Builder::enrollmentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnrollmentStatus").build()}).build();
    private static final SdkField<String> ENROLLMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UserData.getter(UserData::enrollmentId)).setter(UserData.setter(Builder::enrollmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnrollmentId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ARN_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, EMAIL_FIELD, ENROLLMENT_STATUS_FIELD, ENROLLMENT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String userArn;
    private final String firstName;
    private final String lastName;
    private final String email;
    private final String enrollmentStatus;
    private final String enrollmentId;

    private UserData(BuilderImpl builder) {
        this.userArn = builder.userArn;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.email = builder.email;
        this.enrollmentStatus = builder.enrollmentStatus;
        this.enrollmentId = builder.enrollmentId;
    }

    public String userArn() {
        return this.userArn;
    }

    public String firstName() {
        return this.firstName;
    }

    public String lastName() {
        return this.lastName;
    }

    public String email() {
        return this.email;
    }

    public EnrollmentStatus enrollmentStatus() {
        return EnrollmentStatus.fromValue(this.enrollmentStatus);
    }

    public String enrollmentStatusAsString() {
        return this.enrollmentStatus;
    }

    public String enrollmentId() {
        return this.enrollmentId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.enrollmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enrollmentId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserData)) {
            return false;
        }
        UserData other = (UserData)obj;
        return Objects.equals(this.userArn(), other.userArn()) && Objects.equals(this.firstName(), other.firstName()) && Objects.equals(this.lastName(), other.lastName()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.enrollmentStatusAsString(), other.enrollmentStatusAsString()) && Objects.equals(this.enrollmentId(), other.enrollmentId());
    }

    public String toString() {
        return ToString.builder((String)"UserData").add("UserArn", (Object)this.userArn()).add("FirstName", (Object)this.firstName()).add("LastName", (Object)this.lastName()).add("Email", (Object)this.email()).add("EnrollmentStatus", (Object)this.enrollmentStatusAsString()).add("EnrollmentId", (Object)this.enrollmentId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserArn": {
                return Optional.ofNullable(clazz.cast(this.userArn()));
            }
            case "FirstName": {
                return Optional.ofNullable(clazz.cast(this.firstName()));
            }
            case "LastName": {
                return Optional.ofNullable(clazz.cast(this.lastName()));
            }
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "EnrollmentStatus": {
                return Optional.ofNullable(clazz.cast(this.enrollmentStatusAsString()));
            }
            case "EnrollmentId": {
                return Optional.ofNullable(clazz.cast(this.enrollmentId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserData, T> g) {
        return obj -> g.apply((UserData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userArn;
        private String firstName;
        private String lastName;
        private String email;
        private String enrollmentStatus;
        private String enrollmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(UserData model) {
            this.userArn(model.userArn);
            this.firstName(model.firstName);
            this.lastName(model.lastName);
            this.email(model.email);
            this.enrollmentStatus(model.enrollmentStatus);
            this.enrollmentId(model.enrollmentId);
        }

        public final String getUserArn() {
            return this.userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public final String getFirstName() {
            return this.firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public final String getLastName() {
            return this.lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public final String getEmail() {
            return this.email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getEnrollmentStatus() {
            return this.enrollmentStatus;
        }

        @Override
        public final Builder enrollmentStatus(String enrollmentStatus) {
            this.enrollmentStatus = enrollmentStatus;
            return this;
        }

        @Override
        public final Builder enrollmentStatus(EnrollmentStatus enrollmentStatus) {
            this.enrollmentStatus(enrollmentStatus.toString());
            return this;
        }

        public final void setEnrollmentStatus(String enrollmentStatus) {
            this.enrollmentStatus = enrollmentStatus;
        }

        public final String getEnrollmentId() {
            return this.enrollmentId;
        }

        @Override
        public final Builder enrollmentId(String enrollmentId) {
            this.enrollmentId = enrollmentId;
            return this;
        }

        public final void setEnrollmentId(String enrollmentId) {
            this.enrollmentId = enrollmentId;
        }

        public UserData build() {
            return new UserData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserData> {
        public Builder userArn(String var1);

        public Builder firstName(String var1);

        public Builder lastName(String var1);

        public Builder email(String var1);

        public Builder enrollmentStatus(String var1);

        public Builder enrollmentStatus(EnrollmentStatus var1);

        public Builder enrollmentId(String var1);
    }
}

