/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A device with attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Device implements SdkPojo, Serializable, ToCopyableBuilder<Device.Builder, Device> {
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Device::deviceArn)).setter(setter(Builder::deviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceArn").build()).build();

    private static final SdkField<String> DEVICE_SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Device::deviceSerialNumber)).setter(setter(Builder::deviceSerialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceSerialNumber").build())
            .build();

    private static final SdkField<String> DEVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Device::deviceType)).setter(setter(Builder::deviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceType").build()).build();

    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Device::deviceName)).setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()).build();

    private static final SdkField<String> SOFTWARE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Device::softwareVersion)).setter(setter(Builder::softwareVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareVersion").build()).build();

    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Device::macAddress)).setter(setter(Builder::macAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacAddress").build()).build();

    private static final SdkField<String> ROOM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Device::roomArn)).setter(setter(Builder::roomArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomArn").build()).build();

    private static final SdkField<String> DEVICE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Device::deviceStatusAsString)).setter(setter(Builder::deviceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceStatus").build()).build();

    private static final SdkField<DeviceStatusInfo> DEVICE_STATUS_INFO_FIELD = SdkField
            .<DeviceStatusInfo> builder(MarshallingType.SDK_POJO).getter(getter(Device::deviceStatusInfo))
            .setter(setter(Builder::deviceStatusInfo)).constructor(DeviceStatusInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceStatusInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ARN_FIELD,
            DEVICE_SERIAL_NUMBER_FIELD, DEVICE_TYPE_FIELD, DEVICE_NAME_FIELD, SOFTWARE_VERSION_FIELD, MAC_ADDRESS_FIELD,
            ROOM_ARN_FIELD, DEVICE_STATUS_FIELD, DEVICE_STATUS_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deviceArn;

    private final String deviceSerialNumber;

    private final String deviceType;

    private final String deviceName;

    private final String softwareVersion;

    private final String macAddress;

    private final String roomArn;

    private final String deviceStatus;

    private final DeviceStatusInfo deviceStatusInfo;

    private Device(BuilderImpl builder) {
        this.deviceArn = builder.deviceArn;
        this.deviceSerialNumber = builder.deviceSerialNumber;
        this.deviceType = builder.deviceType;
        this.deviceName = builder.deviceName;
        this.softwareVersion = builder.softwareVersion;
        this.macAddress = builder.macAddress;
        this.roomArn = builder.roomArn;
        this.deviceStatus = builder.deviceStatus;
        this.deviceStatusInfo = builder.deviceStatusInfo;
    }

    /**
     * <p>
     * The ARN of a device.
     * </p>
     * 
     * @return The ARN of a device.
     */
    public String deviceArn() {
        return deviceArn;
    }

    /**
     * <p>
     * The serial number of a device.
     * </p>
     * 
     * @return The serial number of a device.
     */
    public String deviceSerialNumber() {
        return deviceSerialNumber;
    }

    /**
     * <p>
     * The type of a device.
     * </p>
     * 
     * @return The type of a device.
     */
    public String deviceType() {
        return deviceType;
    }

    /**
     * <p>
     * The name of a device.
     * </p>
     * 
     * @return The name of a device.
     */
    public String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The software version of a device.
     * </p>
     * 
     * @return The software version of a device.
     */
    public String softwareVersion() {
        return softwareVersion;
    }

    /**
     * <p>
     * The MAC address of a device.
     * </p>
     * 
     * @return The MAC address of a device.
     */
    public String macAddress() {
        return macAddress;
    }

    /**
     * <p>
     * The room ARN of a device.
     * </p>
     * 
     * @return The room ARN of a device.
     */
    public String roomArn() {
        return roomArn;
    }

    /**
     * <p>
     * The status of a device. If the status is not READY, check the DeviceStatusInfo value for details.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceStatus} will
     * return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceStatusAsString}.
     * </p>
     * 
     * @return The status of a device. If the status is not READY, check the DeviceStatusInfo value for details.
     * @see DeviceStatus
     */
    public DeviceStatus deviceStatus() {
        return DeviceStatus.fromValue(deviceStatus);
    }

    /**
     * <p>
     * The status of a device. If the status is not READY, check the DeviceStatusInfo value for details.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceStatus} will
     * return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceStatusAsString}.
     * </p>
     * 
     * @return The status of a device. If the status is not READY, check the DeviceStatusInfo value for details.
     * @see DeviceStatus
     */
    public String deviceStatusAsString() {
        return deviceStatus;
    }

    /**
     * <p>
     * Detailed information about a device's status.
     * </p>
     * 
     * @return Detailed information about a device's status.
     */
    public DeviceStatusInfo deviceStatusInfo() {
        return deviceStatusInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceSerialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(deviceType());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(softwareVersion());
        hashCode = 31 * hashCode + Objects.hashCode(macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceStatusInfo());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Device)) {
            return false;
        }
        Device other = (Device) obj;
        return Objects.equals(deviceArn(), other.deviceArn()) && Objects.equals(deviceSerialNumber(), other.deviceSerialNumber())
                && Objects.equals(deviceType(), other.deviceType()) && Objects.equals(deviceName(), other.deviceName())
                && Objects.equals(softwareVersion(), other.softwareVersion()) && Objects.equals(macAddress(), other.macAddress())
                && Objects.equals(roomArn(), other.roomArn())
                && Objects.equals(deviceStatusAsString(), other.deviceStatusAsString())
                && Objects.equals(deviceStatusInfo(), other.deviceStatusInfo());
    }

    @Override
    public String toString() {
        return ToString.builder("Device").add("DeviceArn", deviceArn()).add("DeviceSerialNumber", deviceSerialNumber())
                .add("DeviceType", deviceType()).add("DeviceName", deviceName()).add("SoftwareVersion", softwareVersion())
                .add("MacAddress", macAddress()).add("RoomArn", roomArn()).add("DeviceStatus", deviceStatusAsString())
                .add("DeviceStatusInfo", deviceStatusInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceArn":
            return Optional.ofNullable(clazz.cast(deviceArn()));
        case "DeviceSerialNumber":
            return Optional.ofNullable(clazz.cast(deviceSerialNumber()));
        case "DeviceType":
            return Optional.ofNullable(clazz.cast(deviceType()));
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "SoftwareVersion":
            return Optional.ofNullable(clazz.cast(softwareVersion()));
        case "MacAddress":
            return Optional.ofNullable(clazz.cast(macAddress()));
        case "RoomArn":
            return Optional.ofNullable(clazz.cast(roomArn()));
        case "DeviceStatus":
            return Optional.ofNullable(clazz.cast(deviceStatusAsString()));
        case "DeviceStatusInfo":
            return Optional.ofNullable(clazz.cast(deviceStatusInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Device, T> g) {
        return obj -> g.apply((Device) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Device> {
        /**
         * <p>
         * The ARN of a device.
         * </p>
         * 
         * @param deviceArn
         *        The ARN of a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * The serial number of a device.
         * </p>
         * 
         * @param deviceSerialNumber
         *        The serial number of a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceSerialNumber(String deviceSerialNumber);

        /**
         * <p>
         * The type of a device.
         * </p>
         * 
         * @param deviceType
         *        The type of a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceType(String deviceType);

        /**
         * <p>
         * The name of a device.
         * </p>
         * 
         * @param deviceName
         *        The name of a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The software version of a device.
         * </p>
         * 
         * @param softwareVersion
         *        The software version of a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softwareVersion(String softwareVersion);

        /**
         * <p>
         * The MAC address of a device.
         * </p>
         * 
         * @param macAddress
         *        The MAC address of a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macAddress(String macAddress);

        /**
         * <p>
         * The room ARN of a device.
         * </p>
         * 
         * @param roomArn
         *        The room ARN of a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomArn(String roomArn);

        /**
         * <p>
         * The status of a device. If the status is not READY, check the DeviceStatusInfo value for details.
         * </p>
         * 
         * @param deviceStatus
         *        The status of a device. If the status is not READY, check the DeviceStatusInfo value for details.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder deviceStatus(String deviceStatus);

        /**
         * <p>
         * The status of a device. If the status is not READY, check the DeviceStatusInfo value for details.
         * </p>
         * 
         * @param deviceStatus
         *        The status of a device. If the status is not READY, check the DeviceStatusInfo value for details.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder deviceStatus(DeviceStatus deviceStatus);

        /**
         * <p>
         * Detailed information about a device's status.
         * </p>
         * 
         * @param deviceStatusInfo
         *        Detailed information about a device's status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceStatusInfo(DeviceStatusInfo deviceStatusInfo);

        /**
         * <p>
         * Detailed information about a device's status.
         * </p>
         * This is a convenience that creates an instance of the {@link DeviceStatusInfo.Builder} avoiding the need to
         * create one manually via {@link DeviceStatusInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeviceStatusInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceStatusInfo(DeviceStatusInfo)}.
         * 
         * @param deviceStatusInfo
         *        a consumer that will call methods on {@link DeviceStatusInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceStatusInfo(DeviceStatusInfo)
         */
        default Builder deviceStatusInfo(Consumer<DeviceStatusInfo.Builder> deviceStatusInfo) {
            return deviceStatusInfo(DeviceStatusInfo.builder().applyMutation(deviceStatusInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String deviceArn;

        private String deviceSerialNumber;

        private String deviceType;

        private String deviceName;

        private String softwareVersion;

        private String macAddress;

        private String roomArn;

        private String deviceStatus;

        private DeviceStatusInfo deviceStatusInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(Device model) {
            deviceArn(model.deviceArn);
            deviceSerialNumber(model.deviceSerialNumber);
            deviceType(model.deviceType);
            deviceName(model.deviceName);
            softwareVersion(model.softwareVersion);
            macAddress(model.macAddress);
            roomArn(model.roomArn);
            deviceStatus(model.deviceStatus);
            deviceStatusInfo(model.deviceStatusInfo);
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final String getDeviceSerialNumber() {
            return deviceSerialNumber;
        }

        @Override
        public final Builder deviceSerialNumber(String deviceSerialNumber) {
            this.deviceSerialNumber = deviceSerialNumber;
            return this;
        }

        public final void setDeviceSerialNumber(String deviceSerialNumber) {
            this.deviceSerialNumber = deviceSerialNumber;
        }

        public final String getDeviceType() {
            return deviceType;
        }

        @Override
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getSoftwareVersion() {
            return softwareVersion;
        }

        @Override
        public final Builder softwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
            return this;
        }

        public final void setSoftwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
        }

        public final String getMacAddress() {
            return macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        public final String getRoomArn() {
            return roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        public final String getDeviceStatus() {
            return deviceStatus;
        }

        @Override
        public final Builder deviceStatus(String deviceStatus) {
            this.deviceStatus = deviceStatus;
            return this;
        }

        @Override
        public final Builder deviceStatus(DeviceStatus deviceStatus) {
            this.deviceStatus(deviceStatus.toString());
            return this;
        }

        public final void setDeviceStatus(String deviceStatus) {
            this.deviceStatus = deviceStatus;
        }

        public final DeviceStatusInfo.Builder getDeviceStatusInfo() {
            return deviceStatusInfo != null ? deviceStatusInfo.toBuilder() : null;
        }

        @Override
        public final Builder deviceStatusInfo(DeviceStatusInfo deviceStatusInfo) {
            this.deviceStatusInfo = deviceStatusInfo;
            return this;
        }

        public final void setDeviceStatusInfo(DeviceStatusInfo.BuilderImpl deviceStatusInfo) {
            this.deviceStatusInfo = deviceStatusInfo != null ? deviceStatusInfo.build() : null;
        }

        @Override
        public Device build() {
            return new Device(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
