/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutConferencePreferenceRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<PutConferencePreferenceRequest.Builder, PutConferencePreferenceRequest> {
    private static final SdkField<ConferencePreference> CONFERENCE_PREFERENCE_FIELD = SdkField
            .<ConferencePreference> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutConferencePreferenceRequest::conferencePreference)).setter(setter(Builder::conferencePreference))
            .constructor(ConferencePreference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConferencePreference").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFERENCE_PREFERENCE_FIELD));

    private final ConferencePreference conferencePreference;

    private PutConferencePreferenceRequest(BuilderImpl builder) {
        super(builder);
        this.conferencePreference = builder.conferencePreference;
    }

    /**
     * <p>
     * The conference preference of a specific conference provider.
     * </p>
     * 
     * @return The conference preference of a specific conference provider.
     */
    public ConferencePreference conferencePreference() {
        return conferencePreference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conferencePreference());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConferencePreferenceRequest)) {
            return false;
        }
        PutConferencePreferenceRequest other = (PutConferencePreferenceRequest) obj;
        return Objects.equals(conferencePreference(), other.conferencePreference());
    }

    @Override
    public String toString() {
        return ToString.builder("PutConferencePreferenceRequest").add("ConferencePreference", conferencePreference()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConferencePreference":
            return Optional.ofNullable(clazz.cast(conferencePreference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutConferencePreferenceRequest, T> g) {
        return obj -> g.apply((PutConferencePreferenceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutConferencePreferenceRequest> {
        /**
         * <p>
         * The conference preference of a specific conference provider.
         * </p>
         * 
         * @param conferencePreference
         *        The conference preference of a specific conference provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conferencePreference(ConferencePreference conferencePreference);

        /**
         * <p>
         * The conference preference of a specific conference provider.
         * </p>
         * This is a convenience that creates an instance of the {@link ConferencePreference.Builder} avoiding the need
         * to create one manually via {@link ConferencePreference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConferencePreference.Builder#build()} is called immediately and
         * its result is passed to {@link #conferencePreference(ConferencePreference)}.
         * 
         * @param conferencePreference
         *        a consumer that will call methods on {@link ConferencePreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conferencePreference(ConferencePreference)
         */
        default Builder conferencePreference(Consumer<ConferencePreference.Builder> conferencePreference) {
            return conferencePreference(ConferencePreference.builder().applyMutation(conferencePreference).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private ConferencePreference conferencePreference;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConferencePreferenceRequest model) {
            super(model);
            conferencePreference(model.conferencePreference);
        }

        public final ConferencePreference.Builder getConferencePreference() {
            return conferencePreference != null ? conferencePreference.toBuilder() : null;
        }

        @Override
        public final Builder conferencePreference(ConferencePreference conferencePreference) {
            this.conferencePreference = conferencePreference;
            return this;
        }

        public final void setConferencePreference(ConferencePreference.BuilderImpl conferencePreference) {
            this.conferencePreference = conferencePreference != null ? conferencePreference.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConferencePreferenceRequest build() {
            return new PutConferencePreferenceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
