/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSkillsStoreSkillsByCategoryResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<ListSkillsStoreSkillsByCategoryResponse.Builder, ListSkillsStoreSkillsByCategoryResponse> {
    private static final SdkField<List<SkillsStoreSkill>> SKILLS_STORE_SKILLS_FIELD = SdkField
            .<List<SkillsStoreSkill>> builder(MarshallingType.LIST)
            .getter(getter(ListSkillsStoreSkillsByCategoryResponse::skillsStoreSkills))
            .setter(setter(Builder::skillsStoreSkills))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillsStoreSkills").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SkillsStoreSkill> builder(MarshallingType.SDK_POJO)
                                            .constructor(SkillsStoreSkill::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSkillsStoreSkillsByCategoryResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKILLS_STORE_SKILLS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<SkillsStoreSkill> skillsStoreSkills;

    private final String nextToken;

    private ListSkillsStoreSkillsByCategoryResponse(BuilderImpl builder) {
        super(builder);
        this.skillsStoreSkills = builder.skillsStoreSkills;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the SkillsStoreSkills property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSkillsStoreSkills() {
        return skillsStoreSkills != null && !(skillsStoreSkills instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The skill store skills.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSkillsStoreSkills()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The skill store skills.
     */
    public List<SkillsStoreSkill> skillsStoreSkills() {
        return skillsStoreSkills;
    }

    /**
     * <p>
     * The tokens used for pagination.
     * </p>
     * 
     * @return The tokens used for pagination.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(skillsStoreSkills());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSkillsStoreSkillsByCategoryResponse)) {
            return false;
        }
        ListSkillsStoreSkillsByCategoryResponse other = (ListSkillsStoreSkillsByCategoryResponse) obj;
        return Objects.equals(skillsStoreSkills(), other.skillsStoreSkills()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListSkillsStoreSkillsByCategoryResponse").add("SkillsStoreSkills", skillsStoreSkills())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkillsStoreSkills":
            return Optional.ofNullable(clazz.cast(skillsStoreSkills()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSkillsStoreSkillsByCategoryResponse, T> g) {
        return obj -> g.apply((ListSkillsStoreSkillsByCategoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSkillsStoreSkillsByCategoryResponse> {
        /**
         * <p>
         * The skill store skills.
         * </p>
         * 
         * @param skillsStoreSkills
         *        The skill store skills.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillsStoreSkills(Collection<SkillsStoreSkill> skillsStoreSkills);

        /**
         * <p>
         * The skill store skills.
         * </p>
         * 
         * @param skillsStoreSkills
         *        The skill store skills.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillsStoreSkills(SkillsStoreSkill... skillsStoreSkills);

        /**
         * <p>
         * The skill store skills.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SkillsStoreSkill>.Builder} avoiding the
         * need to create one manually via {@link List<SkillsStoreSkill>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SkillsStoreSkill>.Builder#build()} is called immediately and
         * its result is passed to {@link #skillsStoreSkills(List<SkillsStoreSkill>)}.
         * 
         * @param skillsStoreSkills
         *        a consumer that will call methods on {@link List<SkillsStoreSkill>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #skillsStoreSkills(List<SkillsStoreSkill>)
         */
        Builder skillsStoreSkills(Consumer<SkillsStoreSkill.Builder>... skillsStoreSkills);

        /**
         * <p>
         * The tokens used for pagination.
         * </p>
         * 
         * @param nextToken
         *        The tokens used for pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private List<SkillsStoreSkill> skillsStoreSkills = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSkillsStoreSkillsByCategoryResponse model) {
            super(model);
            skillsStoreSkills(model.skillsStoreSkills);
            nextToken(model.nextToken);
        }

        public final Collection<SkillsStoreSkill.Builder> getSkillsStoreSkills() {
            return skillsStoreSkills != null ? skillsStoreSkills.stream().map(SkillsStoreSkill::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder skillsStoreSkills(Collection<SkillsStoreSkill> skillsStoreSkills) {
            this.skillsStoreSkills = SkillsStoreSkillListCopier.copy(skillsStoreSkills);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skillsStoreSkills(SkillsStoreSkill... skillsStoreSkills) {
            skillsStoreSkills(Arrays.asList(skillsStoreSkills));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skillsStoreSkills(Consumer<SkillsStoreSkill.Builder>... skillsStoreSkills) {
            skillsStoreSkills(Stream.of(skillsStoreSkills).map(c -> SkillsStoreSkill.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSkillsStoreSkills(Collection<SkillsStoreSkill.BuilderImpl> skillsStoreSkills) {
            this.skillsStoreSkills = SkillsStoreSkillListCopier.copyFromBuilder(skillsStoreSkills);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSkillsStoreSkillsByCategoryResponse build() {
            return new ListSkillsStoreSkillsByCategoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
