/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGatewayGroupsResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<ListGatewayGroupsResponse.Builder, ListGatewayGroupsResponse> {
    private static final SdkField<List<GatewayGroupSummary>> GATEWAY_GROUPS_FIELD = SdkField
            .<List<GatewayGroupSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListGatewayGroupsResponse::gatewayGroups))
            .setter(setter(Builder::gatewayGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GatewayGroupSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(GatewayGroupSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListGatewayGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_GROUPS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<GatewayGroupSummary> gatewayGroups;

    private final String nextToken;

    private ListGatewayGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayGroups = builder.gatewayGroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the GatewayGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasGatewayGroups() {
        return gatewayGroups != null && !(gatewayGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The gateway groups in the list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGatewayGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The gateway groups in the list.
     */
    public List<GatewayGroupSummary> gatewayGroups() {
        return gatewayGroups;
    }

    /**
     * <p>
     * The token used to paginate though multiple pages of gateway group summaries.
     * </p>
     * 
     * @return The token used to paginate though multiple pages of gateway group summaries.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayGroups());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGatewayGroupsResponse)) {
            return false;
        }
        ListGatewayGroupsResponse other = (ListGatewayGroupsResponse) obj;
        return Objects.equals(gatewayGroups(), other.gatewayGroups()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListGatewayGroupsResponse").add("GatewayGroups", gatewayGroups()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayGroups":
            return Optional.ofNullable(clazz.cast(gatewayGroups()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGatewayGroupsResponse, T> g) {
        return obj -> g.apply((ListGatewayGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListGatewayGroupsResponse> {
        /**
         * <p>
         * The gateway groups in the list.
         * </p>
         * 
         * @param gatewayGroups
         *        The gateway groups in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayGroups(Collection<GatewayGroupSummary> gatewayGroups);

        /**
         * <p>
         * The gateway groups in the list.
         * </p>
         * 
         * @param gatewayGroups
         *        The gateway groups in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayGroups(GatewayGroupSummary... gatewayGroups);

        /**
         * <p>
         * The gateway groups in the list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GatewayGroupSummary>.Builder} avoiding the
         * need to create one manually via {@link List<GatewayGroupSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GatewayGroupSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #gatewayGroups(List<GatewayGroupSummary>)}.
         * 
         * @param gatewayGroups
         *        a consumer that will call methods on {@link List<GatewayGroupSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gatewayGroups(List<GatewayGroupSummary>)
         */
        Builder gatewayGroups(Consumer<GatewayGroupSummary.Builder>... gatewayGroups);

        /**
         * <p>
         * The token used to paginate though multiple pages of gateway group summaries.
         * </p>
         * 
         * @param nextToken
         *        The token used to paginate though multiple pages of gateway group summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private List<GatewayGroupSummary> gatewayGroups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGatewayGroupsResponse model) {
            super(model);
            gatewayGroups(model.gatewayGroups);
            nextToken(model.nextToken);
        }

        public final Collection<GatewayGroupSummary.Builder> getGatewayGroups() {
            return gatewayGroups != null ? gatewayGroups.stream().map(GatewayGroupSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gatewayGroups(Collection<GatewayGroupSummary> gatewayGroups) {
            this.gatewayGroups = GatewayGroupSummariesCopier.copy(gatewayGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayGroups(GatewayGroupSummary... gatewayGroups) {
            gatewayGroups(Arrays.asList(gatewayGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayGroups(Consumer<GatewayGroupSummary.Builder>... gatewayGroups) {
            gatewayGroups(Stream.of(gatewayGroups).map(c -> GatewayGroupSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setGatewayGroups(Collection<GatewayGroupSummary.BuilderImpl> gatewayGroups) {
            this.gatewayGroups = GatewayGroupSummariesCopier.copyFromBuilder(gatewayGroups);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListGatewayGroupsResponse build() {
            return new ListGatewayGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
