/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchRoomsResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<SearchRoomsResponse.Builder, SearchRoomsResponse> {
    private static final SdkField<List<RoomData>> ROOMS_FIELD = SdkField
            .<List<RoomData>> builder(MarshallingType.LIST)
            .getter(getter(SearchRoomsResponse::rooms))
            .setter(setter(Builder::rooms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rooms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoomData> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoomData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchRoomsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SearchRoomsResponse::totalCount)).setter(setter(Builder::totalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOMS_FIELD, NEXT_TOKEN_FIELD,
            TOTAL_COUNT_FIELD));

    private final List<RoomData> rooms;

    private final String nextToken;

    private final Integer totalCount;

    private SearchRoomsResponse(BuilderImpl builder) {
        super(builder);
        this.rooms = builder.rooms;
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
    }

    /**
     * Returns true if the Rooms property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRooms() {
        return rooms != null && !(rooms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rooms that meet the specified set of filter criteria, in sort order.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRooms()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The rooms that meet the specified set of filter criteria, in sort order.
     */
    public List<RoomData> rooms() {
        return rooms;
    }

    /**
     * <p>
     * The token returned to indicate that there is more data available.
     * </p>
     * 
     * @return The token returned to indicate that there is more data available.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The total number of rooms returned.
     * </p>
     * 
     * @return The total number of rooms returned.
     */
    public Integer totalCount() {
        return totalCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(rooms());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRoomsResponse)) {
            return false;
        }
        SearchRoomsResponse other = (SearchRoomsResponse) obj;
        return Objects.equals(rooms(), other.rooms()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(totalCount(), other.totalCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SearchRoomsResponse").add("Rooms", rooms()).add("NextToken", nextToken())
                .add("TotalCount", totalCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rooms":
            return Optional.ofNullable(clazz.cast(rooms()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "TotalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchRoomsResponse, T> g) {
        return obj -> g.apply((SearchRoomsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchRoomsResponse> {
        /**
         * <p>
         * The rooms that meet the specified set of filter criteria, in sort order.
         * </p>
         * 
         * @param rooms
         *        The rooms that meet the specified set of filter criteria, in sort order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rooms(Collection<RoomData> rooms);

        /**
         * <p>
         * The rooms that meet the specified set of filter criteria, in sort order.
         * </p>
         * 
         * @param rooms
         *        The rooms that meet the specified set of filter criteria, in sort order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rooms(RoomData... rooms);

        /**
         * <p>
         * The rooms that meet the specified set of filter criteria, in sort order.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RoomData>.Builder} avoiding the need to
         * create one manually via {@link List<RoomData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RoomData>.Builder#build()} is called immediately and its
         * result is passed to {@link #rooms(List<RoomData>)}.
         * 
         * @param rooms
         *        a consumer that will call methods on {@link List<RoomData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rooms(List<RoomData>)
         */
        Builder rooms(Consumer<RoomData.Builder>... rooms);

        /**
         * <p>
         * The token returned to indicate that there is more data available.
         * </p>
         * 
         * @param nextToken
         *        The token returned to indicate that there is more data available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The total number of rooms returned.
         * </p>
         * 
         * @param totalCount
         *        The total number of rooms returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Integer totalCount);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private List<RoomData> rooms = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchRoomsResponse model) {
            super(model);
            rooms(model.rooms);
            nextToken(model.nextToken);
            totalCount(model.totalCount);
        }

        public final Collection<RoomData.Builder> getRooms() {
            return rooms != null ? rooms.stream().map(RoomData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rooms(Collection<RoomData> rooms) {
            this.rooms = RoomDataListCopier.copy(rooms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rooms(RoomData... rooms) {
            rooms(Arrays.asList(rooms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rooms(Consumer<RoomData.Builder>... rooms) {
            rooms(Stream.of(rooms).map(c -> RoomData.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRooms(Collection<RoomData.BuilderImpl> rooms) {
            this.rooms = RoomDataListCopier.copyFromBuilder(rooms);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getTotalCount() {
            return totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public SearchRoomsResponse build() {
            return new SearchRoomsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
