/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates settings for the instant booking feature that are applied to a room profile. If instant booking is enabled,
 * Alexa automatically reserves a room if it is free when a user joins a meeting with Alexa.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateInstantBooking implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateInstantBooking.Builder, UpdateInstantBooking> {
    private static final SdkField<Integer> DURATION_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateInstantBooking::durationInMinutes)).setter(setter(Builder::durationInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInMinutes").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateInstantBooking::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_IN_MINUTES_FIELD,
            ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer durationInMinutes;

    private final Boolean enabled;

    private UpdateInstantBooking(BuilderImpl builder) {
        this.durationInMinutes = builder.durationInMinutes;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * Duration between 15 and 240 minutes at increments of 15 that determines how long to book an available room when a
     * meeting is started with Alexa.
     * </p>
     * 
     * @return Duration between 15 and 240 minutes at increments of 15 that determines how long to book an available
     *         room when a meeting is started with Alexa.
     */
    public Integer durationInMinutes() {
        return durationInMinutes;
    }

    /**
     * <p>
     * Whether instant booking is enabled or not.
     * </p>
     * 
     * @return Whether instant booking is enabled or not.
     */
    public Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(durationInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInstantBooking)) {
            return false;
        }
        UpdateInstantBooking other = (UpdateInstantBooking) obj;
        return Objects.equals(durationInMinutes(), other.durationInMinutes()) && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateInstantBooking").add("DurationInMinutes", durationInMinutes()).add("Enabled", enabled())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DurationInMinutes":
            return Optional.ofNullable(clazz.cast(durationInMinutes()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInstantBooking, T> g) {
        return obj -> g.apply((UpdateInstantBooking) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateInstantBooking> {
        /**
         * <p>
         * Duration between 15 and 240 minutes at increments of 15 that determines how long to book an available room
         * when a meeting is started with Alexa.
         * </p>
         * 
         * @param durationInMinutes
         *        Duration between 15 and 240 minutes at increments of 15 that determines how long to book an available
         *        room when a meeting is started with Alexa.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInMinutes(Integer durationInMinutes);

        /**
         * <p>
         * Whether instant booking is enabled or not.
         * </p>
         * 
         * @param enabled
         *        Whether instant booking is enabled or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private Integer durationInMinutes;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInstantBooking model) {
            durationInMinutes(model.durationInMinutes);
            enabled(model.enabled);
        }

        public final Integer getDurationInMinutes() {
            return durationInMinutes;
        }

        @Override
        public final Builder durationInMinutes(Integer durationInMinutes) {
            this.durationInMinutes = durationInMinutes;
            return this;
        }

        public final void setDurationInMinutes(Integer durationInMinutes) {
            this.durationInMinutes = durationInMinutes;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public UpdateInstantBooking build() {
            return new UpdateInstantBooking(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
