/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Usage report with specified parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BusinessReport implements SdkPojo, Serializable, ToCopyableBuilder<BusinessReport.Builder, BusinessReport> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BusinessReport::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BusinessReport::failureCodeAsString)).setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").build()).build();

    private static final SdkField<BusinessReportS3Location> S3_LOCATION_FIELD = SdkField
            .<BusinessReportS3Location> builder(MarshallingType.SDK_POJO).getter(getter(BusinessReport::s3Location))
            .setter(setter(Builder::s3Location)).constructor(BusinessReportS3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Location").build()).build();

    private static final SdkField<Instant> DELIVERY_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(BusinessReport::deliveryTime)).setter(setter(Builder::deliveryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryTime").build()).build();

    private static final SdkField<String> DOWNLOAD_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BusinessReport::downloadUrl)).setter(setter(Builder::downloadUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DownloadUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            FAILURE_CODE_FIELD, S3_LOCATION_FIELD, DELIVERY_TIME_FIELD, DOWNLOAD_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String failureCode;

    private final BusinessReportS3Location s3Location;

    private final Instant deliveryTime;

    private final String downloadUrl;

    private BusinessReport(BuilderImpl builder) {
        this.status = builder.status;
        this.failureCode = builder.failureCode;
        this.s3Location = builder.s3Location;
        this.deliveryTime = builder.deliveryTime;
        this.downloadUrl = builder.downloadUrl;
    }

    /**
     * <p>
     * The status of the report generation execution (RUNNING, SUCCEEDED, or FAILED).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BusinessReportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the report generation execution (RUNNING, SUCCEEDED, or FAILED).
     * @see BusinessReportStatus
     */
    public BusinessReportStatus status() {
        return BusinessReportStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the report generation execution (RUNNING, SUCCEEDED, or FAILED).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BusinessReportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the report generation execution (RUNNING, SUCCEEDED, or FAILED).
     * @see BusinessReportStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The failure code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link BusinessReportFailureCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The failure code.
     * @see BusinessReportFailureCode
     */
    public BusinessReportFailureCode failureCode() {
        return BusinessReportFailureCode.fromValue(failureCode);
    }

    /**
     * <p>
     * The failure code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link BusinessReportFailureCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The failure code.
     * @see BusinessReportFailureCode
     */
    public String failureCodeAsString() {
        return failureCode;
    }

    /**
     * <p>
     * The S3 location of the output reports.
     * </p>
     * 
     * @return The S3 location of the output reports.
     */
    public BusinessReportS3Location s3Location() {
        return s3Location;
    }

    /**
     * <p>
     * The time of report delivery.
     * </p>
     * 
     * @return The time of report delivery.
     */
    public Instant deliveryTime() {
        return deliveryTime;
    }

    /**
     * <p>
     * The download link where a user can download the report.
     * </p>
     * 
     * @return The download link where a user can download the report.
     */
    public String downloadUrl() {
        return downloadUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Location());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryTime());
        hashCode = 31 * hashCode + Objects.hashCode(downloadUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BusinessReport)) {
            return false;
        }
        BusinessReport other = (BusinessReport) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureCodeAsString(), other.failureCodeAsString())
                && Objects.equals(s3Location(), other.s3Location()) && Objects.equals(deliveryTime(), other.deliveryTime())
                && Objects.equals(downloadUrl(), other.downloadUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BusinessReport").add("Status", statusAsString()).add("FailureCode", failureCodeAsString())
                .add("S3Location", s3Location()).add("DeliveryTime", deliveryTime()).add("DownloadUrl", downloadUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "FailureCode":
            return Optional.ofNullable(clazz.cast(failureCodeAsString()));
        case "S3Location":
            return Optional.ofNullable(clazz.cast(s3Location()));
        case "DeliveryTime":
            return Optional.ofNullable(clazz.cast(deliveryTime()));
        case "DownloadUrl":
            return Optional.ofNullable(clazz.cast(downloadUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BusinessReport, T> g) {
        return obj -> g.apply((BusinessReport) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BusinessReport> {
        /**
         * <p>
         * The status of the report generation execution (RUNNING, SUCCEEDED, or FAILED).
         * </p>
         * 
         * @param status
         *        The status of the report generation execution (RUNNING, SUCCEEDED, or FAILED).
         * @see BusinessReportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BusinessReportStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the report generation execution (RUNNING, SUCCEEDED, or FAILED).
         * </p>
         * 
         * @param status
         *        The status of the report generation execution (RUNNING, SUCCEEDED, or FAILED).
         * @see BusinessReportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BusinessReportStatus
         */
        Builder status(BusinessReportStatus status);

        /**
         * <p>
         * The failure code.
         * </p>
         * 
         * @param failureCode
         *        The failure code.
         * @see BusinessReportFailureCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BusinessReportFailureCode
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The failure code.
         * </p>
         * 
         * @param failureCode
         *        The failure code.
         * @see BusinessReportFailureCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BusinessReportFailureCode
         */
        Builder failureCode(BusinessReportFailureCode failureCode);

        /**
         * <p>
         * The S3 location of the output reports.
         * </p>
         * 
         * @param s3Location
         *        The S3 location of the output reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Location(BusinessReportS3Location s3Location);

        /**
         * <p>
         * The S3 location of the output reports.
         * </p>
         * This is a convenience that creates an instance of the {@link BusinessReportS3Location.Builder} avoiding the
         * need to create one manually via {@link BusinessReportS3Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link BusinessReportS3Location.Builder#build()} is called immediately
         * and its result is passed to {@link #s3Location(BusinessReportS3Location)}.
         * 
         * @param s3Location
         *        a consumer that will call methods on {@link BusinessReportS3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Location(BusinessReportS3Location)
         */
        default Builder s3Location(Consumer<BusinessReportS3Location.Builder> s3Location) {
            return s3Location(BusinessReportS3Location.builder().applyMutation(s3Location).build());
        }

        /**
         * <p>
         * The time of report delivery.
         * </p>
         * 
         * @param deliveryTime
         *        The time of report delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryTime(Instant deliveryTime);

        /**
         * <p>
         * The download link where a user can download the report.
         * </p>
         * 
         * @param downloadUrl
         *        The download link where a user can download the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downloadUrl(String downloadUrl);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String failureCode;

        private BusinessReportS3Location s3Location;

        private Instant deliveryTime;

        private String downloadUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(BusinessReport model) {
            status(model.status);
            failureCode(model.failureCode);
            s3Location(model.s3Location);
            deliveryTime(model.deliveryTime);
            downloadUrl(model.downloadUrl);
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BusinessReportStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getFailureCodeAsString() {
            return failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(BusinessReportFailureCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        public final BusinessReportS3Location.Builder getS3Location() {
            return s3Location != null ? s3Location.toBuilder() : null;
        }

        @Override
        public final Builder s3Location(BusinessReportS3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final void setS3Location(BusinessReportS3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        public final Instant getDeliveryTime() {
            return deliveryTime;
        }

        @Override
        public final Builder deliveryTime(Instant deliveryTime) {
            this.deliveryTime = deliveryTime;
            return this;
        }

        public final void setDeliveryTime(Instant deliveryTime) {
            this.deliveryTime = deliveryTime;
        }

        public final String getDownloadUrl() {
            return downloadUrl;
        }

        @Override
        public final Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        public final void setDownloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
        }

        @Override
        public BusinessReport build() {
            return new BusinessReport(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
