/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGatewayGroupResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<GetGatewayGroupResponse.Builder, GetGatewayGroupResponse> {
    private static final SdkField<GatewayGroup> GATEWAY_GROUP_FIELD = SdkField.<GatewayGroup> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetGatewayGroupResponse::gatewayGroup)).setter(setter(Builder::gatewayGroup))
            .constructor(GatewayGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_GROUP_FIELD));

    private final GatewayGroup gatewayGroup;

    private GetGatewayGroupResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayGroup = builder.gatewayGroup;
    }

    /**
     * Returns the value of the GatewayGroup property for this object.
     * 
     * @return The value of the GatewayGroup property for this object.
     */
    public GatewayGroup gatewayGroup() {
        return gatewayGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayGroup());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGatewayGroupResponse)) {
            return false;
        }
        GetGatewayGroupResponse other = (GetGatewayGroupResponse) obj;
        return Objects.equals(gatewayGroup(), other.gatewayGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetGatewayGroupResponse").add("GatewayGroup", gatewayGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayGroup":
            return Optional.ofNullable(clazz.cast(gatewayGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGatewayGroupResponse, T> g) {
        return obj -> g.apply((GetGatewayGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetGatewayGroupResponse> {
        /**
         * Sets the value of the GatewayGroup property for this object.
         *
         * @param gatewayGroup
         *        The new value for the GatewayGroup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayGroup(GatewayGroup gatewayGroup);

        /**
         * Sets the value of the GatewayGroup property for this object.
         *
         * This is a convenience that creates an instance of the {@link GatewayGroup.Builder} avoiding the need to
         * create one manually via {@link GatewayGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link GatewayGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #gatewayGroup(GatewayGroup)}.
         * 
         * @param gatewayGroup
         *        a consumer that will call methods on {@link GatewayGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gatewayGroup(GatewayGroup)
         */
        default Builder gatewayGroup(Consumer<GatewayGroup.Builder> gatewayGroup) {
            return gatewayGroup(GatewayGroup.builder().applyMutation(gatewayGroup).build());
        }
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private GatewayGroup gatewayGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGatewayGroupResponse model) {
            super(model);
            gatewayGroup(model.gatewayGroup);
        }

        public final GatewayGroup.Builder getGatewayGroup() {
            return gatewayGroup != null ? gatewayGroup.toBuilder() : null;
        }

        @Override
        public final Builder gatewayGroup(GatewayGroup gatewayGroup) {
            this.gatewayGroup = gatewayGroup;
            return this;
        }

        public final void setGatewayGroup(GatewayGroup.BuilderImpl gatewayGroup) {
            this.gatewayGroup = gatewayGroup != null ? gatewayGroup.build() : null;
        }

        @Override
        public GetGatewayGroupResponse build() {
            return new GetGatewayGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
