/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A smart home appliance that can connect to a central system. Any domestic device can be a smart appliance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SmartHomeAppliance implements SdkPojo, Serializable,
        ToCopyableBuilder<SmartHomeAppliance.Builder, SmartHomeAppliance> {
    private static final SdkField<String> FRIENDLY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SmartHomeAppliance::friendlyName)).setter(setter(Builder::friendlyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FriendlyName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SmartHomeAppliance::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> MANUFACTURER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SmartHomeAppliance::manufacturerName)).setter(setter(Builder::manufacturerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManufacturerName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRIENDLY_NAME_FIELD,
            DESCRIPTION_FIELD, MANUFACTURER_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String friendlyName;

    private final String description;

    private final String manufacturerName;

    private SmartHomeAppliance(BuilderImpl builder) {
        this.friendlyName = builder.friendlyName;
        this.description = builder.description;
        this.manufacturerName = builder.manufacturerName;
    }

    /**
     * <p>
     * The friendly name of the smart home appliance.
     * </p>
     * 
     * @return The friendly name of the smart home appliance.
     */
    public String friendlyName() {
        return friendlyName;
    }

    /**
     * <p>
     * The description of the smart home appliance.
     * </p>
     * 
     * @return The description of the smart home appliance.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The name of the manufacturer of the smart home appliance.
     * </p>
     * 
     * @return The name of the manufacturer of the smart home appliance.
     */
    public String manufacturerName() {
        return manufacturerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(friendlyName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(manufacturerName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SmartHomeAppliance)) {
            return false;
        }
        SmartHomeAppliance other = (SmartHomeAppliance) obj;
        return Objects.equals(friendlyName(), other.friendlyName()) && Objects.equals(description(), other.description())
                && Objects.equals(manufacturerName(), other.manufacturerName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SmartHomeAppliance").add("FriendlyName", friendlyName()).add("Description", description())
                .add("ManufacturerName", manufacturerName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FriendlyName":
            return Optional.ofNullable(clazz.cast(friendlyName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ManufacturerName":
            return Optional.ofNullable(clazz.cast(manufacturerName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SmartHomeAppliance, T> g) {
        return obj -> g.apply((SmartHomeAppliance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SmartHomeAppliance> {
        /**
         * <p>
         * The friendly name of the smart home appliance.
         * </p>
         * 
         * @param friendlyName
         *        The friendly name of the smart home appliance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder friendlyName(String friendlyName);

        /**
         * <p>
         * The description of the smart home appliance.
         * </p>
         * 
         * @param description
         *        The description of the smart home appliance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the manufacturer of the smart home appliance.
         * </p>
         * 
         * @param manufacturerName
         *        The name of the manufacturer of the smart home appliance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manufacturerName(String manufacturerName);
    }

    static final class BuilderImpl implements Builder {
        private String friendlyName;

        private String description;

        private String manufacturerName;

        private BuilderImpl() {
        }

        private BuilderImpl(SmartHomeAppliance model) {
            friendlyName(model.friendlyName);
            description(model.description);
            manufacturerName(model.manufacturerName);
        }

        public final String getFriendlyName() {
            return friendlyName;
        }

        @Override
        public final Builder friendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            return this;
        }

        public final void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getManufacturerName() {
            return manufacturerName;
        }

        @Override
        public final Builder manufacturerName(String manufacturerName) {
            this.manufacturerName = manufacturerName;
            return this;
        }

        public final void setManufacturerName(String manufacturerName) {
            this.manufacturerName = manufacturerName;
        }

        @Override
        public SmartHomeAppliance build() {
            return new SmartHomeAppliance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
