/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminder;
import software.amazon.awssdk.services.alexaforbusiness.model.InstantBooking;
import software.amazon.awssdk.services.alexaforbusiness.model.RequireCheckIn;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MeetingRoomConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MeetingRoomConfiguration> {
    private static final SdkField<Boolean> ROOM_UTILIZATION_METRICS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(MeetingRoomConfiguration.getter(MeetingRoomConfiguration::roomUtilizationMetricsEnabled)).setter(MeetingRoomConfiguration.setter(Builder::roomUtilizationMetricsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomUtilizationMetricsEnabled").build()}).build();
    private static final SdkField<EndOfMeetingReminder> END_OF_MEETING_REMINDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(MeetingRoomConfiguration.getter(MeetingRoomConfiguration::endOfMeetingReminder)).setter(MeetingRoomConfiguration.setter(Builder::endOfMeetingReminder)).constructor(EndOfMeetingReminder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOfMeetingReminder").build()}).build();
    private static final SdkField<InstantBooking> INSTANT_BOOKING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(MeetingRoomConfiguration.getter(MeetingRoomConfiguration::instantBooking)).setter(MeetingRoomConfiguration.setter(Builder::instantBooking)).constructor(InstantBooking::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstantBooking").build()}).build();
    private static final SdkField<RequireCheckIn> REQUIRE_CHECK_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(MeetingRoomConfiguration.getter(MeetingRoomConfiguration::requireCheckIn)).setter(MeetingRoomConfiguration.setter(Builder::requireCheckIn)).constructor(RequireCheckIn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireCheckIn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_UTILIZATION_METRICS_ENABLED_FIELD, END_OF_MEETING_REMINDER_FIELD, INSTANT_BOOKING_FIELD, REQUIRE_CHECK_IN_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean roomUtilizationMetricsEnabled;
    private final EndOfMeetingReminder endOfMeetingReminder;
    private final InstantBooking instantBooking;
    private final RequireCheckIn requireCheckIn;

    private MeetingRoomConfiguration(BuilderImpl builder) {
        this.roomUtilizationMetricsEnabled = builder.roomUtilizationMetricsEnabled;
        this.endOfMeetingReminder = builder.endOfMeetingReminder;
        this.instantBooking = builder.instantBooking;
        this.requireCheckIn = builder.requireCheckIn;
    }

    public Boolean roomUtilizationMetricsEnabled() {
        return this.roomUtilizationMetricsEnabled;
    }

    public EndOfMeetingReminder endOfMeetingReminder() {
        return this.endOfMeetingReminder;
    }

    public InstantBooking instantBooking() {
        return this.instantBooking;
    }

    public RequireCheckIn requireCheckIn() {
        return this.requireCheckIn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roomUtilizationMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOfMeetingReminder());
        hashCode = 31 * hashCode + Objects.hashCode(this.instantBooking());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireCheckIn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeetingRoomConfiguration)) {
            return false;
        }
        MeetingRoomConfiguration other = (MeetingRoomConfiguration)obj;
        return Objects.equals(this.roomUtilizationMetricsEnabled(), other.roomUtilizationMetricsEnabled()) && Objects.equals(this.endOfMeetingReminder(), other.endOfMeetingReminder()) && Objects.equals(this.instantBooking(), other.instantBooking()) && Objects.equals(this.requireCheckIn(), other.requireCheckIn());
    }

    public String toString() {
        return ToString.builder((String)"MeetingRoomConfiguration").add("RoomUtilizationMetricsEnabled", (Object)this.roomUtilizationMetricsEnabled()).add("EndOfMeetingReminder", (Object)this.endOfMeetingReminder()).add("InstantBooking", (Object)this.instantBooking()).add("RequireCheckIn", (Object)this.requireCheckIn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoomUtilizationMetricsEnabled": {
                return Optional.ofNullable(clazz.cast(this.roomUtilizationMetricsEnabled()));
            }
            case "EndOfMeetingReminder": {
                return Optional.ofNullable(clazz.cast(this.endOfMeetingReminder()));
            }
            case "InstantBooking": {
                return Optional.ofNullable(clazz.cast(this.instantBooking()));
            }
            case "RequireCheckIn": {
                return Optional.ofNullable(clazz.cast(this.requireCheckIn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MeetingRoomConfiguration, T> g) {
        return obj -> g.apply((MeetingRoomConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean roomUtilizationMetricsEnabled;
        private EndOfMeetingReminder endOfMeetingReminder;
        private InstantBooking instantBooking;
        private RequireCheckIn requireCheckIn;

        private BuilderImpl() {
        }

        private BuilderImpl(MeetingRoomConfiguration model) {
            this.roomUtilizationMetricsEnabled(model.roomUtilizationMetricsEnabled);
            this.endOfMeetingReminder(model.endOfMeetingReminder);
            this.instantBooking(model.instantBooking);
            this.requireCheckIn(model.requireCheckIn);
        }

        public final Boolean getRoomUtilizationMetricsEnabled() {
            return this.roomUtilizationMetricsEnabled;
        }

        @Override
        public final Builder roomUtilizationMetricsEnabled(Boolean roomUtilizationMetricsEnabled) {
            this.roomUtilizationMetricsEnabled = roomUtilizationMetricsEnabled;
            return this;
        }

        public final void setRoomUtilizationMetricsEnabled(Boolean roomUtilizationMetricsEnabled) {
            this.roomUtilizationMetricsEnabled = roomUtilizationMetricsEnabled;
        }

        public final EndOfMeetingReminder.Builder getEndOfMeetingReminder() {
            return this.endOfMeetingReminder != null ? this.endOfMeetingReminder.toBuilder() : null;
        }

        @Override
        public final Builder endOfMeetingReminder(EndOfMeetingReminder endOfMeetingReminder) {
            this.endOfMeetingReminder = endOfMeetingReminder;
            return this;
        }

        public final void setEndOfMeetingReminder(EndOfMeetingReminder.BuilderImpl endOfMeetingReminder) {
            this.endOfMeetingReminder = endOfMeetingReminder != null ? endOfMeetingReminder.build() : null;
        }

        public final InstantBooking.Builder getInstantBooking() {
            return this.instantBooking != null ? this.instantBooking.toBuilder() : null;
        }

        @Override
        public final Builder instantBooking(InstantBooking instantBooking) {
            this.instantBooking = instantBooking;
            return this;
        }

        public final void setInstantBooking(InstantBooking.BuilderImpl instantBooking) {
            this.instantBooking = instantBooking != null ? instantBooking.build() : null;
        }

        public final RequireCheckIn.Builder getRequireCheckIn() {
            return this.requireCheckIn != null ? this.requireCheckIn.toBuilder() : null;
        }

        @Override
        public final Builder requireCheckIn(RequireCheckIn requireCheckIn) {
            this.requireCheckIn = requireCheckIn;
            return this;
        }

        public final void setRequireCheckIn(RequireCheckIn.BuilderImpl requireCheckIn) {
            this.requireCheckIn = requireCheckIn != null ? requireCheckIn.build() : null;
        }

        public MeetingRoomConfiguration build() {
            return new MeetingRoomConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MeetingRoomConfiguration> {
        public Builder roomUtilizationMetricsEnabled(Boolean var1);

        public Builder endOfMeetingReminder(EndOfMeetingReminder var1);

        default public Builder endOfMeetingReminder(Consumer<EndOfMeetingReminder.Builder> endOfMeetingReminder) {
            return this.endOfMeetingReminder((EndOfMeetingReminder)((EndOfMeetingReminder.Builder)EndOfMeetingReminder.builder().applyMutation(endOfMeetingReminder)).build());
        }

        public Builder instantBooking(InstantBooking var1);

        default public Builder instantBooking(Consumer<InstantBooking.Builder> instantBooking) {
            return this.instantBooking((InstantBooking)((InstantBooking.Builder)InstantBooking.builder().applyMutation(instantBooking)).build());
        }

        public Builder requireCheckIn(RequireCheckIn var1);

        default public Builder requireCheckIn(Consumer<RequireCheckIn.Builder> requireCheckIn) {
            return this.requireCheckIn((RequireCheckIn)((RequireCheckIn.Builder)RequireCheckIn.builder().applyMutation(requireCheckIn)).build());
        }
    }
}

