/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates meeting room settings of a room profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMeetingRoomConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateMeetingRoomConfiguration.Builder, CreateMeetingRoomConfiguration> {
    private static final SdkField<Boolean> ROOM_UTILIZATION_METRICS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateMeetingRoomConfiguration::roomUtilizationMetricsEnabled))
            .setter(setter(Builder::roomUtilizationMetricsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomUtilizationMetricsEnabled")
                    .build()).build();

    private static final SdkField<CreateEndOfMeetingReminder> END_OF_MEETING_REMINDER_FIELD = SdkField
            .<CreateEndOfMeetingReminder> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateMeetingRoomConfiguration::endOfMeetingReminder)).setter(setter(Builder::endOfMeetingReminder))
            .constructor(CreateEndOfMeetingReminder::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOfMeetingReminder").build())
            .build();

    private static final SdkField<CreateInstantBooking> INSTANT_BOOKING_FIELD = SdkField
            .<CreateInstantBooking> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateMeetingRoomConfiguration::instantBooking)).setter(setter(Builder::instantBooking))
            .constructor(CreateInstantBooking::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstantBooking").build()).build();

    private static final SdkField<CreateRequireCheckIn> REQUIRE_CHECK_IN_FIELD = SdkField
            .<CreateRequireCheckIn> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateMeetingRoomConfiguration::requireCheckIn)).setter(setter(Builder::requireCheckIn))
            .constructor(CreateRequireCheckIn::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireCheckIn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ROOM_UTILIZATION_METRICS_ENABLED_FIELD, END_OF_MEETING_REMINDER_FIELD,
                    INSTANT_BOOKING_FIELD, REQUIRE_CHECK_IN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean roomUtilizationMetricsEnabled;

    private final CreateEndOfMeetingReminder endOfMeetingReminder;

    private final CreateInstantBooking instantBooking;

    private final CreateRequireCheckIn requireCheckIn;

    private CreateMeetingRoomConfiguration(BuilderImpl builder) {
        this.roomUtilizationMetricsEnabled = builder.roomUtilizationMetricsEnabled;
        this.endOfMeetingReminder = builder.endOfMeetingReminder;
        this.instantBooking = builder.instantBooking;
        this.requireCheckIn = builder.requireCheckIn;
    }

    /**
     * <p>
     * Whether room utilization metrics are enabled or not.
     * </p>
     * 
     * @return Whether room utilization metrics are enabled or not.
     */
    public Boolean roomUtilizationMetricsEnabled() {
        return roomUtilizationMetricsEnabled;
    }

    /**
     * Returns the value of the EndOfMeetingReminder property for this object.
     * 
     * @return The value of the EndOfMeetingReminder property for this object.
     */
    public CreateEndOfMeetingReminder endOfMeetingReminder() {
        return endOfMeetingReminder;
    }

    /**
     * <p>
     * Settings to automatically book a room for a configured duration if it's free when joining a meeting with Alexa.
     * </p>
     * 
     * @return Settings to automatically book a room for a configured duration if it's free when joining a meeting with
     *         Alexa.
     */
    public CreateInstantBooking instantBooking() {
        return instantBooking;
    }

    /**
     * <p>
     * Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it's not
     * checked into to make the room available for others. Users can check in by joining the meeting with Alexa or an
     * AVS device, or by saying “Alexa, check in.”
     * </p>
     * 
     * @return Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it's
     *         not checked into to make the room available for others. Users can check in by joining the meeting with
     *         Alexa or an AVS device, or by saying “Alexa, check in.”
     */
    public CreateRequireCheckIn requireCheckIn() {
        return requireCheckIn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roomUtilizationMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(endOfMeetingReminder());
        hashCode = 31 * hashCode + Objects.hashCode(instantBooking());
        hashCode = 31 * hashCode + Objects.hashCode(requireCheckIn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMeetingRoomConfiguration)) {
            return false;
        }
        CreateMeetingRoomConfiguration other = (CreateMeetingRoomConfiguration) obj;
        return Objects.equals(roomUtilizationMetricsEnabled(), other.roomUtilizationMetricsEnabled())
                && Objects.equals(endOfMeetingReminder(), other.endOfMeetingReminder())
                && Objects.equals(instantBooking(), other.instantBooking())
                && Objects.equals(requireCheckIn(), other.requireCheckIn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateMeetingRoomConfiguration")
                .add("RoomUtilizationMetricsEnabled", roomUtilizationMetricsEnabled())
                .add("EndOfMeetingReminder", endOfMeetingReminder()).add("InstantBooking", instantBooking())
                .add("RequireCheckIn", requireCheckIn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoomUtilizationMetricsEnabled":
            return Optional.ofNullable(clazz.cast(roomUtilizationMetricsEnabled()));
        case "EndOfMeetingReminder":
            return Optional.ofNullable(clazz.cast(endOfMeetingReminder()));
        case "InstantBooking":
            return Optional.ofNullable(clazz.cast(instantBooking()));
        case "RequireCheckIn":
            return Optional.ofNullable(clazz.cast(requireCheckIn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMeetingRoomConfiguration, T> g) {
        return obj -> g.apply((CreateMeetingRoomConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateMeetingRoomConfiguration> {
        /**
         * <p>
         * Whether room utilization metrics are enabled or not.
         * </p>
         * 
         * @param roomUtilizationMetricsEnabled
         *        Whether room utilization metrics are enabled or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomUtilizationMetricsEnabled(Boolean roomUtilizationMetricsEnabled);

        /**
         * Sets the value of the EndOfMeetingReminder property for this object.
         *
         * @param endOfMeetingReminder
         *        The new value for the EndOfMeetingReminder property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOfMeetingReminder(CreateEndOfMeetingReminder endOfMeetingReminder);

        /**
         * Sets the value of the EndOfMeetingReminder property for this object.
         *
         * This is a convenience that creates an instance of the {@link CreateEndOfMeetingReminder.Builder} avoiding the
         * need to create one manually via {@link CreateEndOfMeetingReminder#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateEndOfMeetingReminder.Builder#build()} is called immediately
         * and its result is passed to {@link #endOfMeetingReminder(CreateEndOfMeetingReminder)}.
         * 
         * @param endOfMeetingReminder
         *        a consumer that will call methods on {@link CreateEndOfMeetingReminder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endOfMeetingReminder(CreateEndOfMeetingReminder)
         */
        default Builder endOfMeetingReminder(Consumer<CreateEndOfMeetingReminder.Builder> endOfMeetingReminder) {
            return endOfMeetingReminder(CreateEndOfMeetingReminder.builder().applyMutation(endOfMeetingReminder).build());
        }

        /**
         * <p>
         * Settings to automatically book a room for a configured duration if it's free when joining a meeting with
         * Alexa.
         * </p>
         * 
         * @param instantBooking
         *        Settings to automatically book a room for a configured duration if it's free when joining a meeting
         *        with Alexa.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instantBooking(CreateInstantBooking instantBooking);

        /**
         * <p>
         * Settings to automatically book a room for a configured duration if it's free when joining a meeting with
         * Alexa.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateInstantBooking.Builder} avoiding the need
         * to create one manually via {@link CreateInstantBooking#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateInstantBooking.Builder#build()} is called immediately and
         * its result is passed to {@link #instantBooking(CreateInstantBooking)}.
         * 
         * @param instantBooking
         *        a consumer that will call methods on {@link CreateInstantBooking.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instantBooking(CreateInstantBooking)
         */
        default Builder instantBooking(Consumer<CreateInstantBooking.Builder> instantBooking) {
            return instantBooking(CreateInstantBooking.builder().applyMutation(instantBooking).build());
        }

        /**
         * <p>
         * Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it's not
         * checked into to make the room available for others. Users can check in by joining the meeting with Alexa or
         * an AVS device, or by saying “Alexa, check in.”
         * </p>
         * 
         * @param requireCheckIn
         *        Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it's
         *        not checked into to make the room available for others. Users can check in by joining the meeting with
         *        Alexa or an AVS device, or by saying “Alexa, check in.”
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireCheckIn(CreateRequireCheckIn requireCheckIn);

        /**
         * <p>
         * Settings for requiring a check in when a room is reserved. Alexa can cancel a room reservation if it's not
         * checked into to make the room available for others. Users can check in by joining the meeting with Alexa or
         * an AVS device, or by saying “Alexa, check in.”
         * </p>
         * This is a convenience that creates an instance of the {@link CreateRequireCheckIn.Builder} avoiding the need
         * to create one manually via {@link CreateRequireCheckIn#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateRequireCheckIn.Builder#build()} is called immediately and
         * its result is passed to {@link #requireCheckIn(CreateRequireCheckIn)}.
         * 
         * @param requireCheckIn
         *        a consumer that will call methods on {@link CreateRequireCheckIn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requireCheckIn(CreateRequireCheckIn)
         */
        default Builder requireCheckIn(Consumer<CreateRequireCheckIn.Builder> requireCheckIn) {
            return requireCheckIn(CreateRequireCheckIn.builder().applyMutation(requireCheckIn).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean roomUtilizationMetricsEnabled;

        private CreateEndOfMeetingReminder endOfMeetingReminder;

        private CreateInstantBooking instantBooking;

        private CreateRequireCheckIn requireCheckIn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMeetingRoomConfiguration model) {
            roomUtilizationMetricsEnabled(model.roomUtilizationMetricsEnabled);
            endOfMeetingReminder(model.endOfMeetingReminder);
            instantBooking(model.instantBooking);
            requireCheckIn(model.requireCheckIn);
        }

        public final Boolean getRoomUtilizationMetricsEnabled() {
            return roomUtilizationMetricsEnabled;
        }

        @Override
        public final Builder roomUtilizationMetricsEnabled(Boolean roomUtilizationMetricsEnabled) {
            this.roomUtilizationMetricsEnabled = roomUtilizationMetricsEnabled;
            return this;
        }

        public final void setRoomUtilizationMetricsEnabled(Boolean roomUtilizationMetricsEnabled) {
            this.roomUtilizationMetricsEnabled = roomUtilizationMetricsEnabled;
        }

        public final CreateEndOfMeetingReminder.Builder getEndOfMeetingReminder() {
            return endOfMeetingReminder != null ? endOfMeetingReminder.toBuilder() : null;
        }

        @Override
        public final Builder endOfMeetingReminder(CreateEndOfMeetingReminder endOfMeetingReminder) {
            this.endOfMeetingReminder = endOfMeetingReminder;
            return this;
        }

        public final void setEndOfMeetingReminder(CreateEndOfMeetingReminder.BuilderImpl endOfMeetingReminder) {
            this.endOfMeetingReminder = endOfMeetingReminder != null ? endOfMeetingReminder.build() : null;
        }

        public final CreateInstantBooking.Builder getInstantBooking() {
            return instantBooking != null ? instantBooking.toBuilder() : null;
        }

        @Override
        public final Builder instantBooking(CreateInstantBooking instantBooking) {
            this.instantBooking = instantBooking;
            return this;
        }

        public final void setInstantBooking(CreateInstantBooking.BuilderImpl instantBooking) {
            this.instantBooking = instantBooking != null ? instantBooking.build() : null;
        }

        public final CreateRequireCheckIn.Builder getRequireCheckIn() {
            return requireCheckIn != null ? requireCheckIn.toBuilder() : null;
        }

        @Override
        public final Builder requireCheckIn(CreateRequireCheckIn requireCheckIn) {
            this.requireCheckIn = requireCheckIn;
            return this;
        }

        public final void setRequireCheckIn(CreateRequireCheckIn.BuilderImpl requireCheckIn) {
            this.requireCheckIn = requireCheckIn != null ? requireCheckIn.build() : null;
        }

        @Override
        public CreateMeetingRoomConfiguration build() {
            return new CreateMeetingRoomConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
