/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRoomSkillParameterRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, GetRoomSkillParameterRequest> {
    private static final SdkField<String> ROOM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetRoomSkillParameterRequest.getter(GetRoomSkillParameterRequest::roomArn)).setter(GetRoomSkillParameterRequest.setter(Builder::roomArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomArn").build()}).build();
    private static final SdkField<String> SKILL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetRoomSkillParameterRequest.getter(GetRoomSkillParameterRequest::skillId)).setter(GetRoomSkillParameterRequest.setter(Builder::skillId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillId").build()}).build();
    private static final SdkField<String> PARAMETER_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetRoomSkillParameterRequest.getter(GetRoomSkillParameterRequest::parameterKey)).setter(GetRoomSkillParameterRequest.setter(Builder::parameterKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_ARN_FIELD, SKILL_ID_FIELD, PARAMETER_KEY_FIELD));
    private final String roomArn;
    private final String skillId;
    private final String parameterKey;

    private GetRoomSkillParameterRequest(BuilderImpl builder) {
        super(builder);
        this.roomArn = builder.roomArn;
        this.skillId = builder.skillId;
        this.parameterKey = builder.parameterKey;
    }

    public String roomArn() {
        return this.roomArn;
    }

    public String skillId() {
        return this.skillId;
    }

    public String parameterKey() {
        return this.parameterKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.skillId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRoomSkillParameterRequest)) {
            return false;
        }
        GetRoomSkillParameterRequest other = (GetRoomSkillParameterRequest)((Object)obj);
        return Objects.equals(this.roomArn(), other.roomArn()) && Objects.equals(this.skillId(), other.skillId()) && Objects.equals(this.parameterKey(), other.parameterKey());
    }

    public String toString() {
        return ToString.builder((String)"GetRoomSkillParameterRequest").add("RoomArn", (Object)this.roomArn()).add("SkillId", (Object)this.skillId()).add("ParameterKey", (Object)this.parameterKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoomArn": {
                return Optional.ofNullable(clazz.cast(this.roomArn()));
            }
            case "SkillId": {
                return Optional.ofNullable(clazz.cast(this.skillId()));
            }
            case "ParameterKey": {
                return Optional.ofNullable(clazz.cast(this.parameterKey()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRoomSkillParameterRequest, T> g) {
        return obj -> g.apply((GetRoomSkillParameterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String roomArn;
        private String skillId;
        private String parameterKey;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRoomSkillParameterRequest model) {
            super(model);
            this.roomArn(model.roomArn);
            this.skillId(model.skillId);
            this.parameterKey(model.parameterKey);
        }

        public final String getRoomArn() {
            return this.roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        public final String getSkillId() {
            return this.skillId;
        }

        @Override
        public final Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public final void setSkillId(String skillId) {
            this.skillId = skillId;
        }

        public final String getParameterKey() {
            return this.parameterKey;
        }

        @Override
        public final Builder parameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
            return this;
        }

        public final void setParameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRoomSkillParameterRequest build() {
            return new GetRoomSkillParameterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRoomSkillParameterRequest> {
        public Builder roomArn(String var1);

        public Builder skillId(String var1);

        public Builder parameterKey(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

