/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRoomRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, UpdateRoomRequest> {
    private static final SdkField<String> ROOM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateRoomRequest.getter(UpdateRoomRequest::roomArn)).setter(UpdateRoomRequest.setter(Builder::roomArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomArn").build()}).build();
    private static final SdkField<String> ROOM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateRoomRequest.getter(UpdateRoomRequest::roomName)).setter(UpdateRoomRequest.setter(Builder::roomName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateRoomRequest.getter(UpdateRoomRequest::description)).setter(UpdateRoomRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> PROVIDER_CALENDAR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateRoomRequest.getter(UpdateRoomRequest::providerCalendarId)).setter(UpdateRoomRequest.setter(Builder::providerCalendarId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderCalendarId").build()}).build();
    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateRoomRequest.getter(UpdateRoomRequest::profileArn)).setter(UpdateRoomRequest.setter(Builder::profileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_ARN_FIELD, ROOM_NAME_FIELD, DESCRIPTION_FIELD, PROVIDER_CALENDAR_ID_FIELD, PROFILE_ARN_FIELD));
    private final String roomArn;
    private final String roomName;
    private final String description;
    private final String providerCalendarId;
    private final String profileArn;

    private UpdateRoomRequest(BuilderImpl builder) {
        super(builder);
        this.roomArn = builder.roomArn;
        this.roomName = builder.roomName;
        this.description = builder.description;
        this.providerCalendarId = builder.providerCalendarId;
        this.profileArn = builder.profileArn;
    }

    public String roomArn() {
        return this.roomArn;
    }

    public String roomName() {
        return this.roomName;
    }

    public String description() {
        return this.description;
    }

    public String providerCalendarId() {
        return this.providerCalendarId;
    }

    public String profileArn() {
        return this.profileArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roomName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerCalendarId());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRoomRequest)) {
            return false;
        }
        UpdateRoomRequest other = (UpdateRoomRequest)((Object)obj);
        return Objects.equals(this.roomArn(), other.roomArn()) && Objects.equals(this.roomName(), other.roomName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.providerCalendarId(), other.providerCalendarId()) && Objects.equals(this.profileArn(), other.profileArn());
    }

    public String toString() {
        return ToString.builder((String)"UpdateRoomRequest").add("RoomArn", (Object)this.roomArn()).add("RoomName", (Object)this.roomName()).add("Description", (Object)this.description()).add("ProviderCalendarId", (Object)this.providerCalendarId()).add("ProfileArn", (Object)this.profileArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoomArn": {
                return Optional.ofNullable(clazz.cast(this.roomArn()));
            }
            case "RoomName": {
                return Optional.ofNullable(clazz.cast(this.roomName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ProviderCalendarId": {
                return Optional.ofNullable(clazz.cast(this.providerCalendarId()));
            }
            case "ProfileArn": {
                return Optional.ofNullable(clazz.cast(this.profileArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRoomRequest, T> g) {
        return obj -> g.apply((UpdateRoomRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String roomArn;
        private String roomName;
        private String description;
        private String providerCalendarId;
        private String profileArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRoomRequest model) {
            super(model);
            this.roomArn(model.roomArn);
            this.roomName(model.roomName);
            this.description(model.description);
            this.providerCalendarId(model.providerCalendarId);
            this.profileArn(model.profileArn);
        }

        public final String getRoomArn() {
            return this.roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        public final String getRoomName() {
            return this.roomName;
        }

        @Override
        public final Builder roomName(String roomName) {
            this.roomName = roomName;
            return this;
        }

        public final void setRoomName(String roomName) {
            this.roomName = roomName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getProviderCalendarId() {
            return this.providerCalendarId;
        }

        @Override
        public final Builder providerCalendarId(String providerCalendarId) {
            this.providerCalendarId = providerCalendarId;
            return this;
        }

        public final void setProviderCalendarId(String providerCalendarId) {
            this.providerCalendarId = providerCalendarId;
        }

        public final String getProfileArn() {
            return this.profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRoomRequest build() {
            return new UpdateRoomRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRoomRequest> {
        public Builder roomArn(String var1);

        public Builder roomName(String var1);

        public Builder description(String var1);

        public Builder providerCalendarId(String var1);

        public Builder profileArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

