/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGatewaysResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<ListGatewaysResponse.Builder, ListGatewaysResponse> {
    private static final SdkField<List<GatewaySummary>> GATEWAYS_FIELD = SdkField
            .<List<GatewaySummary>> builder(MarshallingType.LIST)
            .getter(getter(ListGatewaysResponse::gateways))
            .setter(setter(Builder::gateways))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gateways").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GatewaySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(GatewaySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListGatewaysResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAYS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<GatewaySummary> gateways;

    private final String nextToken;

    private ListGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.gateways = builder.gateways;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Gateways property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasGateways() {
        return gateways != null && !(gateways instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The gateways in the list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGateways()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The gateways in the list.
     */
    public List<GatewaySummary> gateways() {
        return gateways;
    }

    /**
     * <p>
     * The token used to paginate though multiple pages of gateway summaries.
     * </p>
     * 
     * @return The token used to paginate though multiple pages of gateway summaries.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gateways());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGatewaysResponse)) {
            return false;
        }
        ListGatewaysResponse other = (ListGatewaysResponse) obj;
        return Objects.equals(gateways(), other.gateways()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListGatewaysResponse").add("Gateways", gateways()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Gateways":
            return Optional.ofNullable(clazz.cast(gateways()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGatewaysResponse, T> g) {
        return obj -> g.apply((ListGatewaysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListGatewaysResponse> {
        /**
         * <p>
         * The gateways in the list.
         * </p>
         * 
         * @param gateways
         *        The gateways in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gateways(Collection<GatewaySummary> gateways);

        /**
         * <p>
         * The gateways in the list.
         * </p>
         * 
         * @param gateways
         *        The gateways in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gateways(GatewaySummary... gateways);

        /**
         * <p>
         * The gateways in the list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GatewaySummary>.Builder} avoiding the need
         * to create one manually via {@link List<GatewaySummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GatewaySummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #gateways(List<GatewaySummary>)}.
         * 
         * @param gateways
         *        a consumer that will call methods on {@link List<GatewaySummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gateways(List<GatewaySummary>)
         */
        Builder gateways(Consumer<GatewaySummary.Builder>... gateways);

        /**
         * <p>
         * The token used to paginate though multiple pages of gateway summaries.
         * </p>
         * 
         * @param nextToken
         *        The token used to paginate though multiple pages of gateway summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private List<GatewaySummary> gateways = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGatewaysResponse model) {
            super(model);
            gateways(model.gateways);
            nextToken(model.nextToken);
        }

        public final Collection<GatewaySummary.Builder> getGateways() {
            return gateways != null ? gateways.stream().map(GatewaySummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gateways(Collection<GatewaySummary> gateways) {
            this.gateways = GatewaySummariesCopier.copy(gateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gateways(GatewaySummary... gateways) {
            gateways(Arrays.asList(gateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gateways(Consumer<GatewaySummary.Builder>... gateways) {
            gateways(Stream.of(gateways).map(c -> GatewaySummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGateways(Collection<GatewaySummary.BuilderImpl> gateways) {
            this.gateways = GatewaySummariesCopier.copyFromBuilder(gateways);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListGatewaysResponse build() {
            return new ListGatewaysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
