/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConferenceProvidersResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<ListConferenceProvidersResponse.Builder, ListConferenceProvidersResponse> {
    private static final SdkField<List<ConferenceProvider>> CONFERENCE_PROVIDERS_FIELD = SdkField
            .<List<ConferenceProvider>> builder(MarshallingType.LIST)
            .getter(getter(ListConferenceProvidersResponse::conferenceProviders))
            .setter(setter(Builder::conferenceProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConferenceProviders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConferenceProvider> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConferenceProvider::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListConferenceProvidersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFERENCE_PROVIDERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ConferenceProvider> conferenceProviders;

    private final String nextToken;

    private ListConferenceProvidersResponse(BuilderImpl builder) {
        super(builder);
        this.conferenceProviders = builder.conferenceProviders;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ConferenceProviders property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasConferenceProviders() {
        return conferenceProviders != null && !(conferenceProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The conference providers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConferenceProviders()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The conference providers.
     */
    public List<ConferenceProvider> conferenceProviders() {
        return conferenceProviders;
    }

    /**
     * <p>
     * The tokens used for pagination.
     * </p>
     * 
     * @return The tokens used for pagination.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(conferenceProviders());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConferenceProvidersResponse)) {
            return false;
        }
        ListConferenceProvidersResponse other = (ListConferenceProvidersResponse) obj;
        return Objects.equals(conferenceProviders(), other.conferenceProviders())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListConferenceProvidersResponse").add("ConferenceProviders", conferenceProviders())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConferenceProviders":
            return Optional.ofNullable(clazz.cast(conferenceProviders()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConferenceProvidersResponse, T> g) {
        return obj -> g.apply((ListConferenceProvidersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListConferenceProvidersResponse> {
        /**
         * <p>
         * The conference providers.
         * </p>
         * 
         * @param conferenceProviders
         *        The conference providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conferenceProviders(Collection<ConferenceProvider> conferenceProviders);

        /**
         * <p>
         * The conference providers.
         * </p>
         * 
         * @param conferenceProviders
         *        The conference providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conferenceProviders(ConferenceProvider... conferenceProviders);

        /**
         * <p>
         * The conference providers.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConferenceProvider>.Builder} avoiding the
         * need to create one manually via {@link List<ConferenceProvider>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConferenceProvider>.Builder#build()} is called immediately
         * and its result is passed to {@link #conferenceProviders(List<ConferenceProvider>)}.
         * 
         * @param conferenceProviders
         *        a consumer that will call methods on {@link List<ConferenceProvider>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conferenceProviders(List<ConferenceProvider>)
         */
        Builder conferenceProviders(Consumer<ConferenceProvider.Builder>... conferenceProviders);

        /**
         * <p>
         * The tokens used for pagination.
         * </p>
         * 
         * @param nextToken
         *        The tokens used for pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private List<ConferenceProvider> conferenceProviders = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConferenceProvidersResponse model) {
            super(model);
            conferenceProviders(model.conferenceProviders);
            nextToken(model.nextToken);
        }

        public final Collection<ConferenceProvider.Builder> getConferenceProviders() {
            return conferenceProviders != null ? conferenceProviders.stream().map(ConferenceProvider::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder conferenceProviders(Collection<ConferenceProvider> conferenceProviders) {
            this.conferenceProviders = ConferenceProvidersListCopier.copy(conferenceProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conferenceProviders(ConferenceProvider... conferenceProviders) {
            conferenceProviders(Arrays.asList(conferenceProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conferenceProviders(Consumer<ConferenceProvider.Builder>... conferenceProviders) {
            conferenceProviders(Stream.of(conferenceProviders).map(c -> ConferenceProvider.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConferenceProviders(Collection<ConferenceProvider.BuilderImpl> conferenceProviders) {
            this.conferenceProviders = ConferenceProvidersListCopier.copyFromBuilder(conferenceProviders);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListConferenceProvidersResponse build() {
            return new ListConferenceProvidersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
