/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateSkillGroupWithRoomRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, AssociateSkillGroupWithRoomRequest> {
    private static final SdkField<String> SKILL_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociateSkillGroupWithRoomRequest.getter(AssociateSkillGroupWithRoomRequest::skillGroupArn)).setter(AssociateSkillGroupWithRoomRequest.setter(Builder::skillGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillGroupArn").build()}).build();
    private static final SdkField<String> ROOM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociateSkillGroupWithRoomRequest.getter(AssociateSkillGroupWithRoomRequest::roomArn)).setter(AssociateSkillGroupWithRoomRequest.setter(Builder::roomArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKILL_GROUP_ARN_FIELD, ROOM_ARN_FIELD));
    private final String skillGroupArn;
    private final String roomArn;

    private AssociateSkillGroupWithRoomRequest(BuilderImpl builder) {
        super(builder);
        this.skillGroupArn = builder.skillGroupArn;
        this.roomArn = builder.roomArn;
    }

    public String skillGroupArn() {
        return this.skillGroupArn;
    }

    public String roomArn() {
        return this.roomArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.skillGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roomArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSkillGroupWithRoomRequest)) {
            return false;
        }
        AssociateSkillGroupWithRoomRequest other = (AssociateSkillGroupWithRoomRequest)((Object)obj);
        return Objects.equals(this.skillGroupArn(), other.skillGroupArn()) && Objects.equals(this.roomArn(), other.roomArn());
    }

    public String toString() {
        return ToString.builder((String)"AssociateSkillGroupWithRoomRequest").add("SkillGroupArn", (Object)this.skillGroupArn()).add("RoomArn", (Object)this.roomArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SkillGroupArn": {
                return Optional.ofNullable(clazz.cast(this.skillGroupArn()));
            }
            case "RoomArn": {
                return Optional.ofNullable(clazz.cast(this.roomArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateSkillGroupWithRoomRequest, T> g) {
        return obj -> g.apply((AssociateSkillGroupWithRoomRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String skillGroupArn;
        private String roomArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSkillGroupWithRoomRequest model) {
            super(model);
            this.skillGroupArn(model.skillGroupArn);
            this.roomArn(model.roomArn);
        }

        public final String getSkillGroupArn() {
            return this.skillGroupArn;
        }

        @Override
        public final Builder skillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
            return this;
        }

        public final void setSkillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
        }

        public final String getRoomArn() {
            return this.roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateSkillGroupWithRoomRequest build() {
            return new AssociateSkillGroupWithRoomRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateSkillGroupWithRoomRequest> {
        public Builder skillGroupArn(String var1);

        public Builder roomArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

