/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.Content;
import software.amazon.awssdk.services.alexaforbusiness.model.Filter;
import software.amazon.awssdk.services.alexaforbusiness.model.FilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendAnnouncementRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, SendAnnouncementRequest> {
    private static final SdkField<List<Filter>> ROOM_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SendAnnouncementRequest.getter(SendAnnouncementRequest::roomFilters)).setter(SendAnnouncementRequest.setter(Builder::roomFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Content> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SendAnnouncementRequest.getter(SendAnnouncementRequest::content)).setter(SendAnnouncementRequest.setter(Builder::content)).constructor(Content::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<Integer> TIME_TO_LIVE_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SendAnnouncementRequest.getter(SendAnnouncementRequest::timeToLiveInSeconds)).setter(SendAnnouncementRequest.setter(Builder::timeToLiveInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeToLiveInSeconds").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendAnnouncementRequest.getter(SendAnnouncementRequest::clientRequestToken)).setter(SendAnnouncementRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_FILTERS_FIELD, CONTENT_FIELD, TIME_TO_LIVE_IN_SECONDS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final List<Filter> roomFilters;
    private final Content content;
    private final Integer timeToLiveInSeconds;
    private final String clientRequestToken;

    private SendAnnouncementRequest(BuilderImpl builder) {
        super(builder);
        this.roomFilters = builder.roomFilters;
        this.content = builder.content;
        this.timeToLiveInSeconds = builder.timeToLiveInSeconds;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public boolean hasRoomFilters() {
        return this.roomFilters != null && !(this.roomFilters instanceof SdkAutoConstructList);
    }

    public List<Filter> roomFilters() {
        return this.roomFilters;
    }

    public Content content() {
        return this.content;
    }

    public Integer timeToLiveInSeconds() {
        return this.timeToLiveInSeconds;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.roomFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeToLiveInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendAnnouncementRequest)) {
            return false;
        }
        SendAnnouncementRequest other = (SendAnnouncementRequest)((Object)obj);
        return Objects.equals(this.roomFilters(), other.roomFilters()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.timeToLiveInSeconds(), other.timeToLiveInSeconds()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public String toString() {
        return ToString.builder((String)"SendAnnouncementRequest").add("RoomFilters", this.roomFilters()).add("Content", (Object)this.content()).add("TimeToLiveInSeconds", (Object)this.timeToLiveInSeconds()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoomFilters": {
                return Optional.ofNullable(clazz.cast(this.roomFilters()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "TimeToLiveInSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeToLiveInSeconds()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendAnnouncementRequest, T> g) {
        return obj -> g.apply((SendAnnouncementRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private List<Filter> roomFilters = DefaultSdkAutoConstructList.getInstance();
        private Content content;
        private Integer timeToLiveInSeconds;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SendAnnouncementRequest model) {
            super(model);
            this.roomFilters(model.roomFilters);
            this.content(model.content);
            this.timeToLiveInSeconds(model.timeToLiveInSeconds);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final Collection<Filter.Builder> getRoomFilters() {
            return this.roomFilters != null ? (Collection)this.roomFilters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder roomFilters(Collection<Filter> roomFilters) {
            this.roomFilters = FilterListCopier.copy(roomFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roomFilters(Filter ... roomFilters) {
            this.roomFilters(Arrays.asList(roomFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roomFilters(Consumer<Filter.Builder> ... roomFilters) {
            this.roomFilters(Stream.of(roomFilters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRoomFilters(Collection<Filter.BuilderImpl> roomFilters) {
            this.roomFilters = FilterListCopier.copyFromBuilder(roomFilters);
        }

        public final Content.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        @Override
        public final Builder content(Content content) {
            this.content = content;
            return this;
        }

        public final void setContent(Content.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        public final Integer getTimeToLiveInSeconds() {
            return this.timeToLiveInSeconds;
        }

        @Override
        public final Builder timeToLiveInSeconds(Integer timeToLiveInSeconds) {
            this.timeToLiveInSeconds = timeToLiveInSeconds;
            return this;
        }

        public final void setTimeToLiveInSeconds(Integer timeToLiveInSeconds) {
            this.timeToLiveInSeconds = timeToLiveInSeconds;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendAnnouncementRequest build() {
            return new SendAnnouncementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendAnnouncementRequest> {
        public Builder roomFilters(Collection<Filter> var1);

        public Builder roomFilters(Filter ... var1);

        public Builder roomFilters(Consumer<Filter.Builder> ... var1);

        public Builder content(Content var1);

        default public Builder content(Consumer<Content.Builder> content) {
            return this.content((Content)((Content.Builder)Content.builder().applyMutation(content)).build());
        }

        public Builder timeToLiveInSeconds(Integer var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

