/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The values that indicate whether a pin is always required (YES), never required (NO), or OPTIONAL.
 * </p>
 * <ul>
 * <li>
 * <p>
 * If YES, Alexa will always ask for a meeting pin.
 * </p>
 * </li>
 * <li>
 * <p>
 * If NO, Alexa will never ask for a meeting pin.
 * </p>
 * </li>
 * <li>
 * <p>
 * If OPTIONAL, Alexa will ask if you have a meeting pin and if the customer responds with yes, it will ask for the
 * meeting pin.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MeetingSetting implements SdkPojo, Serializable, ToCopyableBuilder<MeetingSetting.Builder, MeetingSetting> {
    private static final SdkField<String> REQUIRE_PIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MeetingSetting::requirePinAsString)).setter(setter(Builder::requirePin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequirePin").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUIRE_PIN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String requirePin;

    private MeetingSetting(BuilderImpl builder) {
        this.requirePin = builder.requirePin;
    }

    /**
     * <p>
     * The values that indicate whether the pin is always required.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requirePin} will
     * return {@link RequirePin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #requirePinAsString}.
     * </p>
     * 
     * @return The values that indicate whether the pin is always required.
     * @see RequirePin
     */
    public RequirePin requirePin() {
        return RequirePin.fromValue(requirePin);
    }

    /**
     * <p>
     * The values that indicate whether the pin is always required.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requirePin} will
     * return {@link RequirePin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #requirePinAsString}.
     * </p>
     * 
     * @return The values that indicate whether the pin is always required.
     * @see RequirePin
     */
    public String requirePinAsString() {
        return requirePin;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(requirePinAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeetingSetting)) {
            return false;
        }
        MeetingSetting other = (MeetingSetting) obj;
        return Objects.equals(requirePinAsString(), other.requirePinAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MeetingSetting").add("RequirePin", requirePinAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequirePin":
            return Optional.ofNullable(clazz.cast(requirePinAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MeetingSetting, T> g) {
        return obj -> g.apply((MeetingSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MeetingSetting> {
        /**
         * <p>
         * The values that indicate whether the pin is always required.
         * </p>
         * 
         * @param requirePin
         *        The values that indicate whether the pin is always required.
         * @see RequirePin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequirePin
         */
        Builder requirePin(String requirePin);

        /**
         * <p>
         * The values that indicate whether the pin is always required.
         * </p>
         * 
         * @param requirePin
         *        The values that indicate whether the pin is always required.
         * @see RequirePin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequirePin
         */
        Builder requirePin(RequirePin requirePin);
    }

    static final class BuilderImpl implements Builder {
        private String requirePin;

        private BuilderImpl() {
        }

        private BuilderImpl(MeetingSetting model) {
            requirePin(model.requirePin);
        }

        public final String getRequirePin() {
            return requirePin;
        }

        @Override
        public final Builder requirePin(String requirePin) {
            this.requirePin = requirePin;
            return this;
        }

        @Override
        public final Builder requirePin(RequirePin requirePin) {
            this.requirePin(requirePin == null ? null : requirePin.toString());
            return this;
        }

        public final void setRequirePin(String requirePin) {
            this.requirePin = requirePin;
        }

        @Override
        public MeetingSetting build() {
            return new MeetingSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
