/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of a device’s status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceStatusDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<DeviceStatusDetail.Builder, DeviceStatusDetail> {
    private static final SdkField<String> FEATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeviceStatusDetail::featureAsString)).setter(setter(Builder::feature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Feature").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeviceStatusDetail::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_FIELD, CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String feature;

    private final String code;

    private DeviceStatusDetail(BuilderImpl builder) {
        this.feature = builder.feature;
        this.code = builder.code;
    }

    /**
     * <p>
     * The list of available features on the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feature} will
     * return {@link Feature#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #featureAsString}.
     * </p>
     * 
     * @return The list of available features on the device.
     * @see Feature
     */
    public Feature feature() {
        return Feature.fromValue(feature);
    }

    /**
     * <p>
     * The list of available features on the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feature} will
     * return {@link Feature#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #featureAsString}.
     * </p>
     * 
     * @return The list of available features on the device.
     * @see Feature
     */
    public String featureAsString() {
        return feature;
    }

    /**
     * <p>
     * The device status detail code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link DeviceStatusDetailCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The device status detail code.
     * @see DeviceStatusDetailCode
     */
    public DeviceStatusDetailCode code() {
        return DeviceStatusDetailCode.fromValue(code);
    }

    /**
     * <p>
     * The device status detail code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link DeviceStatusDetailCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return The device status detail code.
     * @see DeviceStatusDetailCode
     */
    public String codeAsString() {
        return code;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(featureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceStatusDetail)) {
            return false;
        }
        DeviceStatusDetail other = (DeviceStatusDetail) obj;
        return Objects.equals(featureAsString(), other.featureAsString()) && Objects.equals(codeAsString(), other.codeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeviceStatusDetail").add("Feature", featureAsString()).add("Code", codeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Feature":
            return Optional.ofNullable(clazz.cast(featureAsString()));
        case "Code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceStatusDetail, T> g) {
        return obj -> g.apply((DeviceStatusDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceStatusDetail> {
        /**
         * <p>
         * The list of available features on the device.
         * </p>
         * 
         * @param feature
         *        The list of available features on the device.
         * @see Feature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Feature
         */
        Builder feature(String feature);

        /**
         * <p>
         * The list of available features on the device.
         * </p>
         * 
         * @param feature
         *        The list of available features on the device.
         * @see Feature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Feature
         */
        Builder feature(Feature feature);

        /**
         * <p>
         * The device status detail code.
         * </p>
         * 
         * @param code
         *        The device status detail code.
         * @see DeviceStatusDetailCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatusDetailCode
         */
        Builder code(String code);

        /**
         * <p>
         * The device status detail code.
         * </p>
         * 
         * @param code
         *        The device status detail code.
         * @see DeviceStatusDetailCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatusDetailCode
         */
        Builder code(DeviceStatusDetailCode code);
    }

    static final class BuilderImpl implements Builder {
        private String feature;

        private String code;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceStatusDetail model) {
            feature(model.feature);
            code(model.code);
        }

        public final String getFeature() {
            return feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public final Builder feature(Feature feature) {
            this.feature(feature == null ? null : feature.toString());
            return this;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(DeviceStatusDetailCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public DeviceStatusDetail build() {
            return new DeviceStatusDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
