/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum DeviceStatusDetailCode {
    DEVICE_SOFTWARE_UPDATE_NEEDED("DEVICE_SOFTWARE_UPDATE_NEEDED"),

    DEVICE_WAS_OFFLINE("DEVICE_WAS_OFFLINE"),

    CREDENTIALS_ACCESS_FAILURE("CREDENTIALS_ACCESS_FAILURE"),

    TLS_VERSION_MISMATCH("TLS_VERSION_MISMATCH"),

    ASSOCIATION_REJECTION("ASSOCIATION_REJECTION"),

    AUTHENTICATION_FAILURE("AUTHENTICATION_FAILURE"),

    DHCP_FAILURE("DHCP_FAILURE"),

    INTERNET_UNAVAILABLE("INTERNET_UNAVAILABLE"),

    DNS_FAILURE("DNS_FAILURE"),

    UNKNOWN_FAILURE("UNKNOWN_FAILURE"),

    CERTIFICATE_ISSUING_LIMIT_EXCEEDED("CERTIFICATE_ISSUING_LIMIT_EXCEEDED"),

    INVALID_CERTIFICATE_AUTHORITY("INVALID_CERTIFICATE_AUTHORITY"),

    NETWORK_PROFILE_NOT_FOUND("NETWORK_PROFILE_NOT_FOUND"),

    INVALID_PASSWORD_STATE("INVALID_PASSWORD_STATE"),

    PASSWORD_NOT_FOUND("PASSWORD_NOT_FOUND"),

    PASSWORD_MANAGER_ACCESS_DENIED("PASSWORD_MANAGER_ACCESS_DENIED"),

    CERTIFICATE_AUTHORITY_ACCESS_DENIED("CERTIFICATE_AUTHORITY_ACCESS_DENIED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DeviceStatusDetailCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DeviceStatusDetailCode corresponding to the value
     */
    public static DeviceStatusDetailCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DeviceStatusDetailCode.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DeviceStatusDetailCode}s
     */
    public static Set<DeviceStatusDetailCode> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
