/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateSkillGroupFromRoomRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<DisassociateSkillGroupFromRoomRequest.Builder, DisassociateSkillGroupFromRoomRequest> {
    private static final SdkField<String> SKILL_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DisassociateSkillGroupFromRoomRequest::skillGroupArn)).setter(setter(Builder::skillGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillGroupArn").build()).build();

    private static final SdkField<String> ROOM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DisassociateSkillGroupFromRoomRequest::roomArn)).setter(setter(Builder::roomArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKILL_GROUP_ARN_FIELD,
            ROOM_ARN_FIELD));

    private final String skillGroupArn;

    private final String roomArn;

    private DisassociateSkillGroupFromRoomRequest(BuilderImpl builder) {
        super(builder);
        this.skillGroupArn = builder.skillGroupArn;
        this.roomArn = builder.roomArn;
    }

    /**
     * <p>
     * The ARN of the skill group to disassociate from a room. Required.
     * </p>
     * 
     * @return The ARN of the skill group to disassociate from a room. Required.
     */
    public String skillGroupArn() {
        return skillGroupArn;
    }

    /**
     * <p>
     * The ARN of the room from which the skill group is to be disassociated. Required.
     * </p>
     * 
     * @return The ARN of the room from which the skill group is to be disassociated. Required.
     */
    public String roomArn() {
        return roomArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(skillGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(roomArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateSkillGroupFromRoomRequest)) {
            return false;
        }
        DisassociateSkillGroupFromRoomRequest other = (DisassociateSkillGroupFromRoomRequest) obj;
        return Objects.equals(skillGroupArn(), other.skillGroupArn()) && Objects.equals(roomArn(), other.roomArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DisassociateSkillGroupFromRoomRequest").add("SkillGroupArn", skillGroupArn())
                .add("RoomArn", roomArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkillGroupArn":
            return Optional.ofNullable(clazz.cast(skillGroupArn()));
        case "RoomArn":
            return Optional.ofNullable(clazz.cast(roomArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateSkillGroupFromRoomRequest, T> g) {
        return obj -> g.apply((DisassociateSkillGroupFromRoomRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateSkillGroupFromRoomRequest> {
        /**
         * <p>
         * The ARN of the skill group to disassociate from a room. Required.
         * </p>
         * 
         * @param skillGroupArn
         *        The ARN of the skill group to disassociate from a room. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillGroupArn(String skillGroupArn);

        /**
         * <p>
         * The ARN of the room from which the skill group is to be disassociated. Required.
         * </p>
         * 
         * @param roomArn
         *        The ARN of the room from which the skill group is to be disassociated. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomArn(String roomArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String skillGroupArn;

        private String roomArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateSkillGroupFromRoomRequest model) {
            super(model);
            skillGroupArn(model.skillGroupArn);
            roomArn(model.roomArn);
        }

        public final String getSkillGroupArn() {
            return skillGroupArn;
        }

        @Override
        public final Builder skillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
            return this;
        }

        public final void setSkillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
        }

        public final String getRoomArn() {
            return roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateSkillGroupFromRoomRequest build() {
            return new DisassociateSkillGroupFromRoomRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
