/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The default conference provider that is used if no other scheduled meetings are detected.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConferencePreference implements SdkPojo, Serializable,
        ToCopyableBuilder<ConferencePreference.Builder, ConferencePreference> {
    private static final SdkField<String> DEFAULT_CONFERENCE_PROVIDER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ConferencePreference::defaultConferenceProviderArn))
            .setter(setter(Builder::defaultConferenceProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultConferenceProviderArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DEFAULT_CONFERENCE_PROVIDER_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String defaultConferenceProviderArn;

    private ConferencePreference(BuilderImpl builder) {
        this.defaultConferenceProviderArn = builder.defaultConferenceProviderArn;
    }

    /**
     * <p>
     * The ARN of the default conference provider.
     * </p>
     * 
     * @return The ARN of the default conference provider.
     */
    public String defaultConferenceProviderArn() {
        return defaultConferenceProviderArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultConferenceProviderArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConferencePreference)) {
            return false;
        }
        ConferencePreference other = (ConferencePreference) obj;
        return Objects.equals(defaultConferenceProviderArn(), other.defaultConferenceProviderArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConferencePreference").add("DefaultConferenceProviderArn", defaultConferenceProviderArn())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultConferenceProviderArn":
            return Optional.ofNullable(clazz.cast(defaultConferenceProviderArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConferencePreference, T> g) {
        return obj -> g.apply((ConferencePreference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConferencePreference> {
        /**
         * <p>
         * The ARN of the default conference provider.
         * </p>
         * 
         * @param defaultConferenceProviderArn
         *        The ARN of the default conference provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultConferenceProviderArn(String defaultConferenceProviderArn);
    }

    static final class BuilderImpl implements Builder {
        private String defaultConferenceProviderArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ConferencePreference model) {
            defaultConferenceProviderArn(model.defaultConferenceProviderArn);
        }

        public final String getDefaultConferenceProviderArn() {
            return defaultConferenceProviderArn;
        }

        @Override
        public final Builder defaultConferenceProviderArn(String defaultConferenceProviderArn) {
            this.defaultConferenceProviderArn = defaultConferenceProviderArn;
            return this;
        }

        public final void setDefaultConferenceProviderArn(String defaultConferenceProviderArn) {
            this.defaultConferenceProviderArn = defaultConferenceProviderArn;
        }

        @Override
        public ConferencePreference build() {
            return new ConferencePreference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
