/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGatewaysRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<ListGatewaysRequest.Builder, ListGatewaysRequest> {
    private static final SdkField<String> GATEWAY_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListGatewaysRequest::gatewayGroupArn)).setter(setter(Builder::gatewayGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayGroupArn").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListGatewaysRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListGatewaysRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_GROUP_ARN_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String gatewayGroupArn;

    private final String nextToken;

    private final Integer maxResults;

    private ListGatewaysRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayGroupArn = builder.gatewayGroupArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The gateway group ARN for which to list gateways.
     * </p>
     * 
     * @return The gateway group ARN for which to list gateways.
     */
    public String gatewayGroupArn() {
        return gatewayGroupArn;
    }

    /**
     * <p>
     * The token used to paginate though multiple pages of gateway summaries.
     * </p>
     * 
     * @return The token used to paginate though multiple pages of gateway summaries.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of gateway summaries to return. The default is 50.
     * </p>
     * 
     * @return The maximum number of gateway summaries to return. The default is 50.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGatewaysRequest)) {
            return false;
        }
        ListGatewaysRequest other = (ListGatewaysRequest) obj;
        return Objects.equals(gatewayGroupArn(), other.gatewayGroupArn()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListGatewaysRequest").add("GatewayGroupArn", gatewayGroupArn()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayGroupArn":
            return Optional.ofNullable(clazz.cast(gatewayGroupArn()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGatewaysRequest, T> g) {
        return obj -> g.apply((ListGatewaysRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListGatewaysRequest> {
        /**
         * <p>
         * The gateway group ARN for which to list gateways.
         * </p>
         * 
         * @param gatewayGroupArn
         *        The gateway group ARN for which to list gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayGroupArn(String gatewayGroupArn);

        /**
         * <p>
         * The token used to paginate though multiple pages of gateway summaries.
         * </p>
         * 
         * @param nextToken
         *        The token used to paginate though multiple pages of gateway summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of gateway summaries to return. The default is 50.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of gateway summaries to return. The default is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String gatewayGroupArn;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGatewaysRequest model) {
            super(model);
            gatewayGroupArn(model.gatewayGroupArn);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getGatewayGroupArn() {
            return gatewayGroupArn;
        }

        @Override
        public final Builder gatewayGroupArn(String gatewayGroupArn) {
            this.gatewayGroupArn = gatewayGroupArn;
            return this;
        }

        public final void setGatewayGroupArn(String gatewayGroupArn) {
            this.gatewayGroupArn = gatewayGroupArn;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGatewaysRequest build() {
            return new ListGatewaysRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
