/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for the end of meeting reminder feature that are applied to a room profile. The end of meeting reminder
 * enables Alexa to remind users when a meeting is ending.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEndOfMeetingReminder implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateEndOfMeetingReminder.Builder, UpdateEndOfMeetingReminder> {
    private static final SdkField<List<Integer>> REMINDER_AT_MINUTES_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .getter(getter(UpdateEndOfMeetingReminder::reminderAtMinutes))
            .setter(setter(Builder::reminderAtMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReminderAtMinutes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REMINDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEndOfMeetingReminder::reminderTypeAsString)).setter(setter(Builder::reminderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReminderType").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateEndOfMeetingReminder::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMINDER_AT_MINUTES_FIELD,
            REMINDER_TYPE_FIELD, ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Integer> reminderAtMinutes;

    private final String reminderType;

    private final Boolean enabled;

    private UpdateEndOfMeetingReminder(BuilderImpl builder) {
        this.reminderAtMinutes = builder.reminderAtMinutes;
        this.reminderType = builder.reminderType;
        this.enabled = builder.enabled;
    }

    /**
     * Returns true if the ReminderAtMinutes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasReminderAtMinutes() {
        return reminderAtMinutes != null && !(reminderAtMinutes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Updates settings for the end of meeting reminder feature that are applied to a room profile. The end of meeting
     * reminder enables Alexa to remind users when a meeting is ending.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReminderAtMinutes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Updates settings for the end of meeting reminder feature that are applied to a room profile. The end of
     *         meeting reminder enables Alexa to remind users when a meeting is ending.
     */
    public List<Integer> reminderAtMinutes() {
        return reminderAtMinutes;
    }

    /**
     * <p>
     * The type of sound that users hear during the end of meeting reminder.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reminderType} will
     * return {@link EndOfMeetingReminderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reminderTypeAsString}.
     * </p>
     * 
     * @return The type of sound that users hear during the end of meeting reminder.
     * @see EndOfMeetingReminderType
     */
    public EndOfMeetingReminderType reminderType() {
        return EndOfMeetingReminderType.fromValue(reminderType);
    }

    /**
     * <p>
     * The type of sound that users hear during the end of meeting reminder.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reminderType} will
     * return {@link EndOfMeetingReminderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reminderTypeAsString}.
     * </p>
     * 
     * @return The type of sound that users hear during the end of meeting reminder.
     * @see EndOfMeetingReminderType
     */
    public String reminderTypeAsString() {
        return reminderType;
    }

    /**
     * <p>
     * Whether an end of meeting reminder is enabled or not.
     * </p>
     * 
     * @return Whether an end of meeting reminder is enabled or not.
     */
    public Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reminderAtMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(reminderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndOfMeetingReminder)) {
            return false;
        }
        UpdateEndOfMeetingReminder other = (UpdateEndOfMeetingReminder) obj;
        return Objects.equals(reminderAtMinutes(), other.reminderAtMinutes())
                && Objects.equals(reminderTypeAsString(), other.reminderTypeAsString())
                && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateEndOfMeetingReminder").add("ReminderAtMinutes", reminderAtMinutes())
                .add("ReminderType", reminderTypeAsString()).add("Enabled", enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReminderAtMinutes":
            return Optional.ofNullable(clazz.cast(reminderAtMinutes()));
        case "ReminderType":
            return Optional.ofNullable(clazz.cast(reminderTypeAsString()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEndOfMeetingReminder, T> g) {
        return obj -> g.apply((UpdateEndOfMeetingReminder) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateEndOfMeetingReminder> {
        /**
         * <p>
         * Updates settings for the end of meeting reminder feature that are applied to a room profile. The end of
         * meeting reminder enables Alexa to remind users when a meeting is ending.
         * </p>
         * 
         * @param reminderAtMinutes
         *        Updates settings for the end of meeting reminder feature that are applied to a room profile. The end
         *        of meeting reminder enables Alexa to remind users when a meeting is ending.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reminderAtMinutes(Collection<Integer> reminderAtMinutes);

        /**
         * <p>
         * Updates settings for the end of meeting reminder feature that are applied to a room profile. The end of
         * meeting reminder enables Alexa to remind users when a meeting is ending.
         * </p>
         * 
         * @param reminderAtMinutes
         *        Updates settings for the end of meeting reminder feature that are applied to a room profile. The end
         *        of meeting reminder enables Alexa to remind users when a meeting is ending.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reminderAtMinutes(Integer... reminderAtMinutes);

        /**
         * <p>
         * The type of sound that users hear during the end of meeting reminder.
         * </p>
         * 
         * @param reminderType
         *        The type of sound that users hear during the end of meeting reminder.
         * @see EndOfMeetingReminderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndOfMeetingReminderType
         */
        Builder reminderType(String reminderType);

        /**
         * <p>
         * The type of sound that users hear during the end of meeting reminder.
         * </p>
         * 
         * @param reminderType
         *        The type of sound that users hear during the end of meeting reminder.
         * @see EndOfMeetingReminderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndOfMeetingReminderType
         */
        Builder reminderType(EndOfMeetingReminderType reminderType);

        /**
         * <p>
         * Whether an end of meeting reminder is enabled or not.
         * </p>
         * 
         * @param enabled
         *        Whether an end of meeting reminder is enabled or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private List<Integer> reminderAtMinutes = DefaultSdkAutoConstructList.getInstance();

        private String reminderType;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndOfMeetingReminder model) {
            reminderAtMinutes(model.reminderAtMinutes);
            reminderType(model.reminderType);
            enabled(model.enabled);
        }

        public final Collection<Integer> getReminderAtMinutes() {
            return reminderAtMinutes;
        }

        @Override
        public final Builder reminderAtMinutes(Collection<Integer> reminderAtMinutes) {
            this.reminderAtMinutes = EndOfMeetingReminderMinutesListCopier.copy(reminderAtMinutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reminderAtMinutes(Integer... reminderAtMinutes) {
            reminderAtMinutes(Arrays.asList(reminderAtMinutes));
            return this;
        }

        public final void setReminderAtMinutes(Collection<Integer> reminderAtMinutes) {
            this.reminderAtMinutes = EndOfMeetingReminderMinutesListCopier.copy(reminderAtMinutes);
        }

        public final String getReminderType() {
            return reminderType;
        }

        @Override
        public final Builder reminderType(String reminderType) {
            this.reminderType = reminderType;
            return this;
        }

        @Override
        public final Builder reminderType(EndOfMeetingReminderType reminderType) {
            this.reminderType(reminderType == null ? null : reminderType.toString());
            return this;
        }

        public final void setReminderType(String reminderType) {
            this.reminderType = reminderType;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public UpdateEndOfMeetingReminder build() {
            return new UpdateEndOfMeetingReminder(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
