/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SkillGroupData;
import software.amazon.awssdk.services.alexaforbusiness.model.SkillGroupDataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchSkillGroupsResponse
extends AlexaForBusinessResponse
implements ToCopyableBuilder<Builder, SearchSkillGroupsResponse> {
    private static final SdkField<List<SkillGroupData>> SKILL_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SkillGroups").getter(SearchSkillGroupsResponse.getter(SearchSkillGroupsResponse::skillGroups)).setter(SearchSkillGroupsResponse.setter(Builder::skillGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SkillGroupData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchSkillGroupsResponse.getter(SearchSkillGroupsResponse::nextToken)).setter(SearchSkillGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalCount").getter(SearchSkillGroupsResponse.getter(SearchSkillGroupsResponse::totalCount)).setter(SearchSkillGroupsResponse.setter(Builder::totalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKILL_GROUPS_FIELD, NEXT_TOKEN_FIELD, TOTAL_COUNT_FIELD));
    private final List<SkillGroupData> skillGroups;
    private final String nextToken;
    private final Integer totalCount;

    private SearchSkillGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.skillGroups = builder.skillGroups;
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
    }

    public boolean hasSkillGroups() {
        return this.skillGroups != null && !(this.skillGroups instanceof SdkAutoConstructList);
    }

    public List<SkillGroupData> skillGroups() {
        return this.skillGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer totalCount() {
        return this.totalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.skillGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchSkillGroupsResponse)) {
            return false;
        }
        SearchSkillGroupsResponse other = (SearchSkillGroupsResponse)((Object)obj);
        return Objects.equals(this.skillGroups(), other.skillGroups()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.totalCount(), other.totalCount());
    }

    public String toString() {
        return ToString.builder((String)"SearchSkillGroupsResponse").add("SkillGroups", this.skillGroups()).add("NextToken", (Object)this.nextToken()).add("TotalCount", (Object)this.totalCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SkillGroups": {
                return Optional.ofNullable(clazz.cast(this.skillGroups()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TotalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchSkillGroupsResponse, T> g) {
        return obj -> g.apply((SearchSkillGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessResponse.BuilderImpl
    implements Builder {
        private List<SkillGroupData> skillGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchSkillGroupsResponse model) {
            super(model);
            this.skillGroups(model.skillGroups);
            this.nextToken(model.nextToken);
            this.totalCount(model.totalCount);
        }

        public final Collection<SkillGroupData.Builder> getSkillGroups() {
            return this.skillGroups != null ? (Collection)this.skillGroups.stream().map(SkillGroupData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder skillGroups(Collection<SkillGroupData> skillGroups) {
            this.skillGroups = SkillGroupDataListCopier.copy(skillGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skillGroups(SkillGroupData ... skillGroups) {
            this.skillGroups(Arrays.asList(skillGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skillGroups(Consumer<SkillGroupData.Builder> ... skillGroups) {
            this.skillGroups(Stream.of(skillGroups).map(c -> (SkillGroupData)((SkillGroupData.Builder)SkillGroupData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSkillGroups(Collection<SkillGroupData.BuilderImpl> skillGroups) {
            this.skillGroups = SkillGroupDataListCopier.copyFromBuilder(skillGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getTotalCount() {
            return this.totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public SearchSkillGroupsResponse build() {
            return new SearchSkillGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchSkillGroupsResponse> {
        public Builder skillGroups(Collection<SkillGroupData> var1);

        public Builder skillGroups(SkillGroupData ... var1);

        public Builder skillGroups(Consumer<SkillGroupData.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder totalCount(Integer var1);
    }
}

