/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchNetworkProfilesResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<SearchNetworkProfilesResponse.Builder, SearchNetworkProfilesResponse> {
    private static final SdkField<List<NetworkProfileData>> NETWORK_PROFILES_FIELD = SdkField
            .<List<NetworkProfileData>> builder(MarshallingType.LIST)
            .memberName("NetworkProfiles")
            .getter(getter(SearchNetworkProfilesResponse::networkProfiles))
            .setter(setter(Builder::networkProfiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkProfiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetworkProfileData> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkProfileData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchNetworkProfilesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalCount").getter(getter(SearchNetworkProfilesResponse::totalCount))
            .setter(setter(Builder::totalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_PROFILES_FIELD,
            NEXT_TOKEN_FIELD, TOTAL_COUNT_FIELD));

    private final List<NetworkProfileData> networkProfiles;

    private final String nextToken;

    private final Integer totalCount;

    private SearchNetworkProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.networkProfiles = builder.networkProfiles;
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
    }

    /**
     * Returns true if the NetworkProfiles property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNetworkProfiles() {
        return networkProfiles != null && !(networkProfiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The network profiles that meet the specified set of filter criteria, in sort order. It is a list of
     * NetworkProfileData objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNetworkProfiles()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The network profiles that meet the specified set of filter criteria, in sort order. It is a list of
     *         NetworkProfileData objects.
     */
    public List<NetworkProfileData> networkProfiles() {
        return networkProfiles;
    }

    /**
     * <p>
     * An optional token returned from a prior request. Use this token for pagination of results from this action. If
     * this parameter is specified, the response includes only results beyond the token, up to the value specified by
     * MaxResults.
     * </p>
     * 
     * @return An optional token returned from a prior request. Use this token for pagination of results from this
     *         action. If this parameter is specified, the response includes only results beyond the token, up to the
     *         value specified by MaxResults.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The total number of network profiles returned.
     * </p>
     * 
     * @return The total number of network profiles returned.
     */
    public Integer totalCount() {
        return totalCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkProfiles());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchNetworkProfilesResponse)) {
            return false;
        }
        SearchNetworkProfilesResponse other = (SearchNetworkProfilesResponse) obj;
        return Objects.equals(networkProfiles(), other.networkProfiles()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(totalCount(), other.totalCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SearchNetworkProfilesResponse").add("NetworkProfiles", networkProfiles())
                .add("NextToken", nextToken()).add("TotalCount", totalCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkProfiles":
            return Optional.ofNullable(clazz.cast(networkProfiles()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "TotalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchNetworkProfilesResponse, T> g) {
        return obj -> g.apply((SearchNetworkProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchNetworkProfilesResponse> {
        /**
         * <p>
         * The network profiles that meet the specified set of filter criteria, in sort order. It is a list of
         * NetworkProfileData objects.
         * </p>
         * 
         * @param networkProfiles
         *        The network profiles that meet the specified set of filter criteria, in sort order. It is a list of
         *        NetworkProfileData objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProfiles(Collection<NetworkProfileData> networkProfiles);

        /**
         * <p>
         * The network profiles that meet the specified set of filter criteria, in sort order. It is a list of
         * NetworkProfileData objects.
         * </p>
         * 
         * @param networkProfiles
         *        The network profiles that meet the specified set of filter criteria, in sort order. It is a list of
         *        NetworkProfileData objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProfiles(NetworkProfileData... networkProfiles);

        /**
         * <p>
         * The network profiles that meet the specified set of filter criteria, in sort order. It is a list of
         * NetworkProfileData objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NetworkProfileData>.Builder} avoiding the
         * need to create one manually via {@link List<NetworkProfileData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NetworkProfileData>.Builder#build()} is called immediately
         * and its result is passed to {@link #networkProfiles(List<NetworkProfileData>)}.
         * 
         * @param networkProfiles
         *        a consumer that will call methods on {@link List<NetworkProfileData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkProfiles(List<NetworkProfileData>)
         */
        Builder networkProfiles(Consumer<NetworkProfileData.Builder>... networkProfiles);

        /**
         * <p>
         * An optional token returned from a prior request. Use this token for pagination of results from this action.
         * If this parameter is specified, the response includes only results beyond the token, up to the value
         * specified by MaxResults.
         * </p>
         * 
         * @param nextToken
         *        An optional token returned from a prior request. Use this token for pagination of results from this
         *        action. If this parameter is specified, the response includes only results beyond the token, up to the
         *        value specified by MaxResults.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The total number of network profiles returned.
         * </p>
         * 
         * @param totalCount
         *        The total number of network profiles returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Integer totalCount);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private List<NetworkProfileData> networkProfiles = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchNetworkProfilesResponse model) {
            super(model);
            networkProfiles(model.networkProfiles);
            nextToken(model.nextToken);
            totalCount(model.totalCount);
        }

        public final Collection<NetworkProfileData.Builder> getNetworkProfiles() {
            return networkProfiles != null ? networkProfiles.stream().map(NetworkProfileData::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkProfiles(Collection<NetworkProfileData> networkProfiles) {
            this.networkProfiles = NetworkProfileDataListCopier.copy(networkProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkProfiles(NetworkProfileData... networkProfiles) {
            networkProfiles(Arrays.asList(networkProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkProfiles(Consumer<NetworkProfileData.Builder>... networkProfiles) {
            networkProfiles(Stream.of(networkProfiles).map(c -> NetworkProfileData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkProfiles(Collection<NetworkProfileData.BuilderImpl> networkProfiles) {
            this.networkProfiles = NetworkProfileDataListCopier.copyFromBuilder(networkProfiles);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getTotalCount() {
            return totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public SearchNetworkProfilesResponse build() {
            return new SearchNetworkProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
