/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.SampleUtterancesCopier;
import software.amazon.awssdk.services.alexaforbusiness.model.SkillDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SkillsStoreSkill
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SkillsStoreSkill> {
    private static final SdkField<String> SKILL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SkillId").getter(SkillsStoreSkill.getter(SkillsStoreSkill::skillId)).setter(SkillsStoreSkill.setter(Builder::skillId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillId").build()}).build();
    private static final SdkField<String> SKILL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SkillName").getter(SkillsStoreSkill.getter(SkillsStoreSkill::skillName)).setter(SkillsStoreSkill.setter(Builder::skillName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillName").build()}).build();
    private static final SdkField<String> SHORT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShortDescription").getter(SkillsStoreSkill.getter(SkillsStoreSkill::shortDescription)).setter(SkillsStoreSkill.setter(Builder::shortDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShortDescription").build()}).build();
    private static final SdkField<String> ICON_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IconUrl").getter(SkillsStoreSkill.getter(SkillsStoreSkill::iconUrl)).setter(SkillsStoreSkill.setter(Builder::iconUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IconUrl").build()}).build();
    private static final SdkField<List<String>> SAMPLE_UTTERANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SampleUtterances").getter(SkillsStoreSkill.getter(SkillsStoreSkill::sampleUtterances)).setter(SkillsStoreSkill.setter(Builder::sampleUtterances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleUtterances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SkillDetails> SKILL_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SkillDetails").getter(SkillsStoreSkill.getter(SkillsStoreSkill::skillDetails)).setter(SkillsStoreSkill.setter(Builder::skillDetails)).constructor(SkillDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillDetails").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_LINKING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsLinking").getter(SkillsStoreSkill.getter(SkillsStoreSkill::supportsLinking)).setter(SkillsStoreSkill.setter(Builder::supportsLinking)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsLinking").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKILL_ID_FIELD, SKILL_NAME_FIELD, SHORT_DESCRIPTION_FIELD, ICON_URL_FIELD, SAMPLE_UTTERANCES_FIELD, SKILL_DETAILS_FIELD, SUPPORTS_LINKING_FIELD));
    private static final long serialVersionUID = 1L;
    private final String skillId;
    private final String skillName;
    private final String shortDescription;
    private final String iconUrl;
    private final List<String> sampleUtterances;
    private final SkillDetails skillDetails;
    private final Boolean supportsLinking;

    private SkillsStoreSkill(BuilderImpl builder) {
        this.skillId = builder.skillId;
        this.skillName = builder.skillName;
        this.shortDescription = builder.shortDescription;
        this.iconUrl = builder.iconUrl;
        this.sampleUtterances = builder.sampleUtterances;
        this.skillDetails = builder.skillDetails;
        this.supportsLinking = builder.supportsLinking;
    }

    public String skillId() {
        return this.skillId;
    }

    public String skillName() {
        return this.skillName;
    }

    public String shortDescription() {
        return this.shortDescription;
    }

    public String iconUrl() {
        return this.iconUrl;
    }

    public boolean hasSampleUtterances() {
        return this.sampleUtterances != null && !(this.sampleUtterances instanceof SdkAutoConstructList);
    }

    public List<String> sampleUtterances() {
        return this.sampleUtterances;
    }

    public SkillDetails skillDetails() {
        return this.skillDetails;
    }

    public Boolean supportsLinking() {
        return this.supportsLinking;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.skillId());
        hashCode = 31 * hashCode + Objects.hashCode(this.skillName());
        hashCode = 31 * hashCode + Objects.hashCode(this.shortDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.iconUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSampleUtterances() ? this.sampleUtterances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.skillDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsLinking());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SkillsStoreSkill)) {
            return false;
        }
        SkillsStoreSkill other = (SkillsStoreSkill)obj;
        return Objects.equals(this.skillId(), other.skillId()) && Objects.equals(this.skillName(), other.skillName()) && Objects.equals(this.shortDescription(), other.shortDescription()) && Objects.equals(this.iconUrl(), other.iconUrl()) && this.hasSampleUtterances() == other.hasSampleUtterances() && Objects.equals(this.sampleUtterances(), other.sampleUtterances()) && Objects.equals(this.skillDetails(), other.skillDetails()) && Objects.equals(this.supportsLinking(), other.supportsLinking());
    }

    public String toString() {
        return ToString.builder((String)"SkillsStoreSkill").add("SkillId", (Object)this.skillId()).add("SkillName", (Object)this.skillName()).add("ShortDescription", (Object)this.shortDescription()).add("IconUrl", (Object)this.iconUrl()).add("SampleUtterances", this.hasSampleUtterances() ? this.sampleUtterances() : null).add("SkillDetails", (Object)this.skillDetails()).add("SupportsLinking", (Object)this.supportsLinking()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SkillId": {
                return Optional.ofNullable(clazz.cast(this.skillId()));
            }
            case "SkillName": {
                return Optional.ofNullable(clazz.cast(this.skillName()));
            }
            case "ShortDescription": {
                return Optional.ofNullable(clazz.cast(this.shortDescription()));
            }
            case "IconUrl": {
                return Optional.ofNullable(clazz.cast(this.iconUrl()));
            }
            case "SampleUtterances": {
                return Optional.ofNullable(clazz.cast(this.sampleUtterances()));
            }
            case "SkillDetails": {
                return Optional.ofNullable(clazz.cast(this.skillDetails()));
            }
            case "SupportsLinking": {
                return Optional.ofNullable(clazz.cast(this.supportsLinking()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SkillsStoreSkill, T> g) {
        return obj -> g.apply((SkillsStoreSkill)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String skillId;
        private String skillName;
        private String shortDescription;
        private String iconUrl;
        private List<String> sampleUtterances = DefaultSdkAutoConstructList.getInstance();
        private SkillDetails skillDetails;
        private Boolean supportsLinking;

        private BuilderImpl() {
        }

        private BuilderImpl(SkillsStoreSkill model) {
            this.skillId(model.skillId);
            this.skillName(model.skillName);
            this.shortDescription(model.shortDescription);
            this.iconUrl(model.iconUrl);
            this.sampleUtterances(model.sampleUtterances);
            this.skillDetails(model.skillDetails);
            this.supportsLinking(model.supportsLinking);
        }

        public final String getSkillId() {
            return this.skillId;
        }

        @Override
        public final Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public final void setSkillId(String skillId) {
            this.skillId = skillId;
        }

        public final String getSkillName() {
            return this.skillName;
        }

        @Override
        public final Builder skillName(String skillName) {
            this.skillName = skillName;
            return this;
        }

        public final void setSkillName(String skillName) {
            this.skillName = skillName;
        }

        public final String getShortDescription() {
            return this.shortDescription;
        }

        @Override
        public final Builder shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        public final void setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
        }

        public final String getIconUrl() {
            return this.iconUrl;
        }

        @Override
        public final Builder iconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
            return this;
        }

        public final void setIconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
        }

        public final Collection<String> getSampleUtterances() {
            if (this.sampleUtterances instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sampleUtterances;
        }

        @Override
        public final Builder sampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(String ... sampleUtterances) {
            this.sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        public final void setSampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesCopier.copy(sampleUtterances);
        }

        public final SkillDetails.Builder getSkillDetails() {
            return this.skillDetails != null ? this.skillDetails.toBuilder() : null;
        }

        @Override
        public final Builder skillDetails(SkillDetails skillDetails) {
            this.skillDetails = skillDetails;
            return this;
        }

        public final void setSkillDetails(SkillDetails.BuilderImpl skillDetails) {
            this.skillDetails = skillDetails != null ? skillDetails.build() : null;
        }

        public final Boolean getSupportsLinking() {
            return this.supportsLinking;
        }

        @Override
        public final Builder supportsLinking(Boolean supportsLinking) {
            this.supportsLinking = supportsLinking;
            return this;
        }

        public final void setSupportsLinking(Boolean supportsLinking) {
            this.supportsLinking = supportsLinking;
        }

        public SkillsStoreSkill build() {
            return new SkillsStoreSkill(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SkillsStoreSkill> {
        public Builder skillId(String var1);

        public Builder skillName(String var1);

        public Builder shortDescription(String var1);

        public Builder iconUrl(String var1);

        public Builder sampleUtterances(Collection<String> var1);

        public Builder sampleUtterances(String ... var1);

        public Builder skillDetails(SkillDetails var1);

        default public Builder skillDetails(Consumer<SkillDetails.Builder> skillDetails) {
            return this.skillDetails((SkillDetails)((SkillDetails.Builder)SkillDetails.builder().applyMutation(skillDetails)).build());
        }

        public Builder supportsLinking(Boolean var1);
    }
}

