/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateContactRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<UpdateContactRequest.Builder, UpdateContactRequest> {
    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactArn").getter(getter(UpdateContactRequest::contactArn)).setter(setter(Builder::contactArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactArn").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(UpdateContactRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirstName").getter(getter(UpdateContactRequest::firstName)).setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastName").getter(getter(UpdateContactRequest::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(UpdateContactRequest::phoneNumber)).setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<List<PhoneNumber>> PHONE_NUMBERS_FIELD = SdkField
            .<List<PhoneNumber>> builder(MarshallingType.LIST)
            .memberName("PhoneNumbers")
            .getter(getter(UpdateContactRequest::phoneNumbers))
            .setter(setter(Builder::phoneNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumbers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhoneNumber> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhoneNumber::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SipAddress>> SIP_ADDRESSES_FIELD = SdkField
            .<List<SipAddress>> builder(MarshallingType.LIST)
            .memberName("SipAddresses")
            .getter(getter(UpdateContactRequest::sipAddresses))
            .setter(setter(Builder::sipAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SipAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SipAddress> builder(MarshallingType.SDK_POJO)
                                            .constructor(SipAddress::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ARN_FIELD,
            DISPLAY_NAME_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, PHONE_NUMBER_FIELD, PHONE_NUMBERS_FIELD, SIP_ADDRESSES_FIELD));

    private final String contactArn;

    private final String displayName;

    private final String firstName;

    private final String lastName;

    private final String phoneNumber;

    private final List<PhoneNumber> phoneNumbers;

    private final List<SipAddress> sipAddresses;

    private UpdateContactRequest(BuilderImpl builder) {
        super(builder);
        this.contactArn = builder.contactArn;
        this.displayName = builder.displayName;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.phoneNumber = builder.phoneNumber;
        this.phoneNumbers = builder.phoneNumbers;
        this.sipAddresses = builder.sipAddresses;
    }

    /**
     * <p>
     * The ARN of the contact to update.
     * </p>
     * 
     * @return The ARN of the contact to update.
     */
    public String contactArn() {
        return contactArn;
    }

    /**
     * <p>
     * The updated display name of the contact.
     * </p>
     * 
     * @return The updated display name of the contact.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The updated first name of the contact.
     * </p>
     * 
     * @return The updated first name of the contact.
     */
    public String firstName() {
        return firstName;
    }

    /**
     * <p>
     * The updated last name of the contact.
     * </p>
     * 
     * @return The updated last name of the contact.
     */
    public String lastName() {
        return lastName;
    }

    /**
     * <p>
     * The updated phone number of the contact. The phone number type defaults to WORK. You can either specify
     * PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which lets you specify the phone number type
     * and multiple numbers.
     * </p>
     * 
     * @return The updated phone number of the contact. The phone number type defaults to WORK. You can either specify
     *         PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which lets you specify the phone
     *         number type and multiple numbers.
     */
    public String phoneNumber() {
        return phoneNumber;
    }

    /**
     * Returns true if the PhoneNumbers property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPhoneNumbers() {
        return phoneNumbers != null && !(phoneNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of phone numbers for the contact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPhoneNumbers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of phone numbers for the contact.
     */
    public List<PhoneNumber> phoneNumbers() {
        return phoneNumbers;
    }

    /**
     * Returns true if the SipAddresses property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSipAddresses() {
        return sipAddresses != null && !(sipAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of SIP addresses for the contact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSipAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of SIP addresses for the contact.
     */
    public List<SipAddress> sipAddresses() {
        return sipAddresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(hasPhoneNumbers() ? phoneNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSipAddresses() ? sipAddresses() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContactRequest)) {
            return false;
        }
        UpdateContactRequest other = (UpdateContactRequest) obj;
        return Objects.equals(contactArn(), other.contactArn()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(firstName(), other.firstName()) && Objects.equals(lastName(), other.lastName())
                && Objects.equals(phoneNumber(), other.phoneNumber()) && hasPhoneNumbers() == other.hasPhoneNumbers()
                && Objects.equals(phoneNumbers(), other.phoneNumbers()) && hasSipAddresses() == other.hasSipAddresses()
                && Objects.equals(sipAddresses(), other.sipAddresses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateContactRequest").add("ContactArn", contactArn()).add("DisplayName", displayName())
                .add("FirstName", firstName()).add("LastName", lastName())
                .add("PhoneNumber", phoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PhoneNumbers", hasPhoneNumbers() ? phoneNumbers() : null)
                .add("SipAddresses", hasSipAddresses() ? sipAddresses() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactArn":
            return Optional.ofNullable(clazz.cast(contactArn()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "FirstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "LastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "PhoneNumbers":
            return Optional.ofNullable(clazz.cast(phoneNumbers()));
        case "SipAddresses":
            return Optional.ofNullable(clazz.cast(sipAddresses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContactRequest, T> g) {
        return obj -> g.apply((UpdateContactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateContactRequest> {
        /**
         * <p>
         * The ARN of the contact to update.
         * </p>
         * 
         * @param contactArn
         *        The ARN of the contact to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactArn(String contactArn);

        /**
         * <p>
         * The updated display name of the contact.
         * </p>
         * 
         * @param displayName
         *        The updated display name of the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The updated first name of the contact.
         * </p>
         * 
         * @param firstName
         *        The updated first name of the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * The updated last name of the contact.
         * </p>
         * 
         * @param lastName
         *        The updated last name of the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * The updated phone number of the contact. The phone number type defaults to WORK. You can either specify
         * PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which lets you specify the phone number
         * type and multiple numbers.
         * </p>
         * 
         * @param phoneNumber
         *        The updated phone number of the contact. The phone number type defaults to WORK. You can either
         *        specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which lets you specify
         *        the phone number type and multiple numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * The list of phone numbers for the contact.
         * </p>
         * 
         * @param phoneNumbers
         *        The list of phone numbers for the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumbers(Collection<PhoneNumber> phoneNumbers);

        /**
         * <p>
         * The list of phone numbers for the contact.
         * </p>
         * 
         * @param phoneNumbers
         *        The list of phone numbers for the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumbers(PhoneNumber... phoneNumbers);

        /**
         * <p>
         * The list of phone numbers for the contact.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PhoneNumber>.Builder} avoiding the need to
         * create one manually via {@link List<PhoneNumber>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PhoneNumber>.Builder#build()} is called immediately and its
         * result is passed to {@link #phoneNumbers(List<PhoneNumber>)}.
         * 
         * @param phoneNumbers
         *        a consumer that will call methods on {@link List<PhoneNumber>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phoneNumbers(List<PhoneNumber>)
         */
        Builder phoneNumbers(Consumer<PhoneNumber.Builder>... phoneNumbers);

        /**
         * <p>
         * The list of SIP addresses for the contact.
         * </p>
         * 
         * @param sipAddresses
         *        The list of SIP addresses for the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sipAddresses(Collection<SipAddress> sipAddresses);

        /**
         * <p>
         * The list of SIP addresses for the contact.
         * </p>
         * 
         * @param sipAddresses
         *        The list of SIP addresses for the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sipAddresses(SipAddress... sipAddresses);

        /**
         * <p>
         * The list of SIP addresses for the contact.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SipAddress>.Builder} avoiding the need to
         * create one manually via {@link List<SipAddress>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SipAddress>.Builder#build()} is called immediately and its
         * result is passed to {@link #sipAddresses(List<SipAddress>)}.
         * 
         * @param sipAddresses
         *        a consumer that will call methods on {@link List<SipAddress>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sipAddresses(List<SipAddress>)
         */
        Builder sipAddresses(Consumer<SipAddress.Builder>... sipAddresses);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String contactArn;

        private String displayName;

        private String firstName;

        private String lastName;

        private String phoneNumber;

        private List<PhoneNumber> phoneNumbers = DefaultSdkAutoConstructList.getInstance();

        private List<SipAddress> sipAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContactRequest model) {
            super(model);
            contactArn(model.contactArn);
            displayName(model.displayName);
            firstName(model.firstName);
            lastName(model.lastName);
            phoneNumber(model.phoneNumber);
            phoneNumbers(model.phoneNumbers);
            sipAddresses(model.sipAddresses);
        }

        public final String getContactArn() {
            return contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getFirstName() {
            return firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public final String getLastName() {
            return lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public final Collection<PhoneNumber.Builder> getPhoneNumbers() {
            if (phoneNumbers instanceof SdkAutoConstructList) {
                return null;
            }
            return phoneNumbers != null ? phoneNumbers.stream().map(PhoneNumber::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder phoneNumbers(Collection<PhoneNumber> phoneNumbers) {
            this.phoneNumbers = PhoneNumberListCopier.copy(phoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(PhoneNumber... phoneNumbers) {
            phoneNumbers(Arrays.asList(phoneNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(Consumer<PhoneNumber.Builder>... phoneNumbers) {
            phoneNumbers(Stream.of(phoneNumbers).map(c -> PhoneNumber.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPhoneNumbers(Collection<PhoneNumber.BuilderImpl> phoneNumbers) {
            this.phoneNumbers = PhoneNumberListCopier.copyFromBuilder(phoneNumbers);
        }

        public final Collection<SipAddress.Builder> getSipAddresses() {
            if (sipAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return sipAddresses != null ? sipAddresses.stream().map(SipAddress::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sipAddresses(Collection<SipAddress> sipAddresses) {
            this.sipAddresses = SipAddressListCopier.copy(sipAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sipAddresses(SipAddress... sipAddresses) {
            sipAddresses(Arrays.asList(sipAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sipAddresses(Consumer<SipAddress.Builder>... sipAddresses) {
            sipAddresses(Stream.of(sipAddresses).map(c -> SipAddress.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSipAddresses(Collection<SipAddress.BuilderImpl> sipAddresses) {
            this.sipAddresses = SipAddressListCopier.copyFromBuilder(sipAddresses);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContactRequest build() {
            return new UpdateContactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
