/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumberType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PhoneNumber
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PhoneNumber> {
    private static final SdkField<String> NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Number").getter(PhoneNumber.getter(PhoneNumber::number)).setter(PhoneNumber.setter(Builder::number)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Number").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(PhoneNumber.getter(PhoneNumber::typeAsString)).setter(PhoneNumber.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String number;
    private final String type;

    private PhoneNumber(BuilderImpl builder) {
        this.number = builder.number;
        this.type = builder.type;
    }

    public String number() {
        return this.number;
    }

    public PhoneNumberType type() {
        return PhoneNumberType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.number());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoneNumber)) {
            return false;
        }
        PhoneNumber other = (PhoneNumber)obj;
        return Objects.equals(this.number(), other.number()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"PhoneNumber").add("Number", (Object)(this.number() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)(this.typeAsString() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Number": {
                return Optional.ofNullable(clazz.cast(this.number()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PhoneNumber, T> g) {
        return obj -> g.apply((PhoneNumber)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String number;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(PhoneNumber model) {
            this.number(model.number);
            this.type(model.type);
        }

        public final String getNumber() {
            return this.number;
        }

        @Override
        public final Builder number(String number) {
            this.number = number;
            return this;
        }

        public final void setNumber(String number) {
            this.number = number;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PhoneNumberType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public PhoneNumber build() {
            return new PhoneNumber(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PhoneNumber> {
        public Builder number(String var1);

        public Builder type(String var1);

        public Builder type(PhoneNumberType var1);
    }
}

