/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An entity that provides a conferencing solution. Alexa for Business acts as the voice interface and mediator that
 * connects users to their preferred conference provider. Examples of conference providers include Amazon Chime, Zoom,
 * Cisco, and Polycom.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConferenceProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<ConferenceProvider.Builder, ConferenceProvider> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ConferenceProvider::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ConferenceProvider::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ConferenceProvider::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<IPDialIn> IP_DIAL_IN_FIELD = SdkField.<IPDialIn> builder(MarshallingType.SDK_POJO)
            .memberName("IPDialIn").getter(getter(ConferenceProvider::ipDialIn)).setter(setter(Builder::ipDialIn))
            .constructor(IPDialIn::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPDialIn").build()).build();

    private static final SdkField<PSTNDialIn> PSTN_DIAL_IN_FIELD = SdkField.<PSTNDialIn> builder(MarshallingType.SDK_POJO)
            .memberName("PSTNDialIn").getter(getter(ConferenceProvider::pstnDialIn)).setter(setter(Builder::pstnDialIn))
            .constructor(PSTNDialIn::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PSTNDialIn").build()).build();

    private static final SdkField<MeetingSetting> MEETING_SETTING_FIELD = SdkField
            .<MeetingSetting> builder(MarshallingType.SDK_POJO).memberName("MeetingSetting")
            .getter(getter(ConferenceProvider::meetingSetting)).setter(setter(Builder::meetingSetting))
            .constructor(MeetingSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingSetting").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            TYPE_FIELD, IP_DIAL_IN_FIELD, PSTN_DIAL_IN_FIELD, MEETING_SETTING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String type;

    private final IPDialIn ipDialIn;

    private final PSTNDialIn pstnDialIn;

    private final MeetingSetting meetingSetting;

    private ConferenceProvider(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.ipDialIn = builder.ipDialIn;
        this.pstnDialIn = builder.pstnDialIn;
        this.meetingSetting = builder.meetingSetting;
    }

    /**
     * <p>
     * The ARN of the newly created conference provider.
     * </p>
     * 
     * @return The ARN of the newly created conference provider.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the conference provider.
     * </p>
     * 
     * @return The name of the conference provider.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The type of conference providers.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ConferenceProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of conference providers.
     * @see ConferenceProviderType
     */
    public ConferenceProviderType type() {
        return ConferenceProviderType.fromValue(type);
    }

    /**
     * <p>
     * The type of conference providers.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ConferenceProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of conference providers.
     * @see ConferenceProviderType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The IP endpoint and protocol for calling.
     * </p>
     * 
     * @return The IP endpoint and protocol for calling.
     */
    public IPDialIn ipDialIn() {
        return ipDialIn;
    }

    /**
     * <p>
     * The information for PSTN conferencing.
     * </p>
     * 
     * @return The information for PSTN conferencing.
     */
    public PSTNDialIn pstnDialIn() {
        return pstnDialIn;
    }

    /**
     * <p>
     * The meeting settings for the conference provider.
     * </p>
     * 
     * @return The meeting settings for the conference provider.
     */
    public MeetingSetting meetingSetting() {
        return meetingSetting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipDialIn());
        hashCode = 31 * hashCode + Objects.hashCode(pstnDialIn());
        hashCode = 31 * hashCode + Objects.hashCode(meetingSetting());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConferenceProvider)) {
            return false;
        }
        ConferenceProvider other = (ConferenceProvider) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(ipDialIn(), other.ipDialIn())
                && Objects.equals(pstnDialIn(), other.pstnDialIn()) && Objects.equals(meetingSetting(), other.meetingSetting());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConferenceProvider").add("Arn", arn()).add("Name", name()).add("Type", typeAsString())
                .add("IPDialIn", ipDialIn()).add("PSTNDialIn", pstnDialIn()).add("MeetingSetting", meetingSetting()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "IPDialIn":
            return Optional.ofNullable(clazz.cast(ipDialIn()));
        case "PSTNDialIn":
            return Optional.ofNullable(clazz.cast(pstnDialIn()));
        case "MeetingSetting":
            return Optional.ofNullable(clazz.cast(meetingSetting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConferenceProvider, T> g) {
        return obj -> g.apply((ConferenceProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConferenceProvider> {
        /**
         * <p>
         * The ARN of the newly created conference provider.
         * </p>
         * 
         * @param arn
         *        The ARN of the newly created conference provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the conference provider.
         * </p>
         * 
         * @param name
         *        The name of the conference provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of conference providers.
         * </p>
         * 
         * @param type
         *        The type of conference providers.
         * @see ConferenceProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConferenceProviderType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of conference providers.
         * </p>
         * 
         * @param type
         *        The type of conference providers.
         * @see ConferenceProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConferenceProviderType
         */
        Builder type(ConferenceProviderType type);

        /**
         * <p>
         * The IP endpoint and protocol for calling.
         * </p>
         * 
         * @param ipDialIn
         *        The IP endpoint and protocol for calling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipDialIn(IPDialIn ipDialIn);

        /**
         * <p>
         * The IP endpoint and protocol for calling.
         * </p>
         * This is a convenience that creates an instance of the {@link IPDialIn.Builder} avoiding the need to create
         * one manually via {@link IPDialIn#builder()}.
         *
         * When the {@link Consumer} completes, {@link IPDialIn.Builder#build()} is called immediately and its result is
         * passed to {@link #ipDialIn(IPDialIn)}.
         * 
         * @param ipDialIn
         *        a consumer that will call methods on {@link IPDialIn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipDialIn(IPDialIn)
         */
        default Builder ipDialIn(Consumer<IPDialIn.Builder> ipDialIn) {
            return ipDialIn(IPDialIn.builder().applyMutation(ipDialIn).build());
        }

        /**
         * <p>
         * The information for PSTN conferencing.
         * </p>
         * 
         * @param pstnDialIn
         *        The information for PSTN conferencing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pstnDialIn(PSTNDialIn pstnDialIn);

        /**
         * <p>
         * The information for PSTN conferencing.
         * </p>
         * This is a convenience that creates an instance of the {@link PSTNDialIn.Builder} avoiding the need to create
         * one manually via {@link PSTNDialIn#builder()}.
         *
         * When the {@link Consumer} completes, {@link PSTNDialIn.Builder#build()} is called immediately and its result
         * is passed to {@link #pstnDialIn(PSTNDialIn)}.
         * 
         * @param pstnDialIn
         *        a consumer that will call methods on {@link PSTNDialIn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pstnDialIn(PSTNDialIn)
         */
        default Builder pstnDialIn(Consumer<PSTNDialIn.Builder> pstnDialIn) {
            return pstnDialIn(PSTNDialIn.builder().applyMutation(pstnDialIn).build());
        }

        /**
         * <p>
         * The meeting settings for the conference provider.
         * </p>
         * 
         * @param meetingSetting
         *        The meeting settings for the conference provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingSetting(MeetingSetting meetingSetting);

        /**
         * <p>
         * The meeting settings for the conference provider.
         * </p>
         * This is a convenience that creates an instance of the {@link MeetingSetting.Builder} avoiding the need to
         * create one manually via {@link MeetingSetting#builder()}.
         *
         * When the {@link Consumer} completes, {@link MeetingSetting.Builder#build()} is called immediately and its
         * result is passed to {@link #meetingSetting(MeetingSetting)}.
         * 
         * @param meetingSetting
         *        a consumer that will call methods on {@link MeetingSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #meetingSetting(MeetingSetting)
         */
        default Builder meetingSetting(Consumer<MeetingSetting.Builder> meetingSetting) {
            return meetingSetting(MeetingSetting.builder().applyMutation(meetingSetting).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String type;

        private IPDialIn ipDialIn;

        private PSTNDialIn pstnDialIn;

        private MeetingSetting meetingSetting;

        private BuilderImpl() {
        }

        private BuilderImpl(ConferenceProvider model) {
            arn(model.arn);
            name(model.name);
            type(model.type);
            ipDialIn(model.ipDialIn);
            pstnDialIn(model.pstnDialIn);
            meetingSetting(model.meetingSetting);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ConferenceProviderType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final IPDialIn.Builder getIpDialIn() {
            return ipDialIn != null ? ipDialIn.toBuilder() : null;
        }

        @Override
        public final Builder ipDialIn(IPDialIn ipDialIn) {
            this.ipDialIn = ipDialIn;
            return this;
        }

        public final void setIpDialIn(IPDialIn.BuilderImpl ipDialIn) {
            this.ipDialIn = ipDialIn != null ? ipDialIn.build() : null;
        }

        public final PSTNDialIn.Builder getPstnDialIn() {
            return pstnDialIn != null ? pstnDialIn.toBuilder() : null;
        }

        @Override
        public final Builder pstnDialIn(PSTNDialIn pstnDialIn) {
            this.pstnDialIn = pstnDialIn;
            return this;
        }

        public final void setPstnDialIn(PSTNDialIn.BuilderImpl pstnDialIn) {
            this.pstnDialIn = pstnDialIn != null ? pstnDialIn.build() : null;
        }

        public final MeetingSetting.Builder getMeetingSetting() {
            return meetingSetting != null ? meetingSetting.toBuilder() : null;
        }

        @Override
        public final Builder meetingSetting(MeetingSetting meetingSetting) {
            this.meetingSetting = meetingSetting;
            return this;
        }

        public final void setMeetingSetting(MeetingSetting.BuilderImpl meetingSetting) {
            this.meetingSetting = meetingSetting != null ? meetingSetting.build() : null;
        }

        @Override
        public ConferenceProvider build() {
            return new ConferenceProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
