/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The recurrence of the reports.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BusinessReportRecurrence implements SdkPojo, Serializable,
        ToCopyableBuilder<BusinessReportRecurrence.Builder, BusinessReportRecurrence> {
    private static final SdkField<String> START_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartDate").getter(getter(BusinessReportRecurrence::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String startDate;

    private BusinessReportRecurrence(BuilderImpl builder) {
        this.startDate = builder.startDate;
    }

    /**
     * <p>
     * The start date.
     * </p>
     * 
     * @return The start date.
     */
    public String startDate() {
        return startDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BusinessReportRecurrence)) {
            return false;
        }
        BusinessReportRecurrence other = (BusinessReportRecurrence) obj;
        return Objects.equals(startDate(), other.startDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BusinessReportRecurrence").add("StartDate", startDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BusinessReportRecurrence, T> g) {
        return obj -> g.apply((BusinessReportRecurrence) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BusinessReportRecurrence> {
        /**
         * <p>
         * The start date.
         * </p>
         * 
         * @param startDate
         *        The start date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(String startDate);
    }

    static final class BuilderImpl implements Builder {
        private String startDate;

        private BuilderImpl() {
        }

        private BuilderImpl(BusinessReportRecurrence model) {
            startDate(model.startDate);
        }

        public final String getStartDate() {
            return startDate;
        }

        @Override
        public final Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        @Override
        public BusinessReportRecurrence build() {
            return new BusinessReportRecurrence(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
