/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.EnablementType;
import software.amazon.awssdk.services.alexaforbusiness.model.SkillType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SkillSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SkillSummary> {
    private static final SdkField<String> SKILL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SkillId").getter(SkillSummary.getter(SkillSummary::skillId)).setter(SkillSummary.setter(Builder::skillId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillId").build()}).build();
    private static final SdkField<String> SKILL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SkillName").getter(SkillSummary.getter(SkillSummary::skillName)).setter(SkillSummary.setter(Builder::skillName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillName").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_LINKING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsLinking").getter(SkillSummary.getter(SkillSummary::supportsLinking)).setter(SkillSummary.setter(Builder::supportsLinking)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsLinking").build()}).build();
    private static final SdkField<String> ENABLEMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnablementType").getter(SkillSummary.getter(SkillSummary::enablementTypeAsString)).setter(SkillSummary.setter(Builder::enablementType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablementType").build()}).build();
    private static final SdkField<String> SKILL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SkillType").getter(SkillSummary.getter(SkillSummary::skillTypeAsString)).setter(SkillSummary.setter(Builder::skillType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKILL_ID_FIELD, SKILL_NAME_FIELD, SUPPORTS_LINKING_FIELD, ENABLEMENT_TYPE_FIELD, SKILL_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String skillId;
    private final String skillName;
    private final Boolean supportsLinking;
    private final String enablementType;
    private final String skillType;

    private SkillSummary(BuilderImpl builder) {
        this.skillId = builder.skillId;
        this.skillName = builder.skillName;
        this.supportsLinking = builder.supportsLinking;
        this.enablementType = builder.enablementType;
        this.skillType = builder.skillType;
    }

    public String skillId() {
        return this.skillId;
    }

    public String skillName() {
        return this.skillName;
    }

    public Boolean supportsLinking() {
        return this.supportsLinking;
    }

    public EnablementType enablementType() {
        return EnablementType.fromValue(this.enablementType);
    }

    public String enablementTypeAsString() {
        return this.enablementType;
    }

    public SkillType skillType() {
        return SkillType.fromValue(this.skillType);
    }

    public String skillTypeAsString() {
        return this.skillType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.skillId());
        hashCode = 31 * hashCode + Objects.hashCode(this.skillName());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsLinking());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.skillTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SkillSummary)) {
            return false;
        }
        SkillSummary other = (SkillSummary)obj;
        return Objects.equals(this.skillId(), other.skillId()) && Objects.equals(this.skillName(), other.skillName()) && Objects.equals(this.supportsLinking(), other.supportsLinking()) && Objects.equals(this.enablementTypeAsString(), other.enablementTypeAsString()) && Objects.equals(this.skillTypeAsString(), other.skillTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"SkillSummary").add("SkillId", (Object)this.skillId()).add("SkillName", (Object)this.skillName()).add("SupportsLinking", (Object)this.supportsLinking()).add("EnablementType", (Object)this.enablementTypeAsString()).add("SkillType", (Object)this.skillTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SkillId": {
                return Optional.ofNullable(clazz.cast(this.skillId()));
            }
            case "SkillName": {
                return Optional.ofNullable(clazz.cast(this.skillName()));
            }
            case "SupportsLinking": {
                return Optional.ofNullable(clazz.cast(this.supportsLinking()));
            }
            case "EnablementType": {
                return Optional.ofNullable(clazz.cast(this.enablementTypeAsString()));
            }
            case "SkillType": {
                return Optional.ofNullable(clazz.cast(this.skillTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SkillSummary, T> g) {
        return obj -> g.apply((SkillSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String skillId;
        private String skillName;
        private Boolean supportsLinking;
        private String enablementType;
        private String skillType;

        private BuilderImpl() {
        }

        private BuilderImpl(SkillSummary model) {
            this.skillId(model.skillId);
            this.skillName(model.skillName);
            this.supportsLinking(model.supportsLinking);
            this.enablementType(model.enablementType);
            this.skillType(model.skillType);
        }

        public final String getSkillId() {
            return this.skillId;
        }

        @Override
        public final Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public final void setSkillId(String skillId) {
            this.skillId = skillId;
        }

        public final String getSkillName() {
            return this.skillName;
        }

        @Override
        public final Builder skillName(String skillName) {
            this.skillName = skillName;
            return this;
        }

        public final void setSkillName(String skillName) {
            this.skillName = skillName;
        }

        public final Boolean getSupportsLinking() {
            return this.supportsLinking;
        }

        @Override
        public final Builder supportsLinking(Boolean supportsLinking) {
            this.supportsLinking = supportsLinking;
            return this;
        }

        public final void setSupportsLinking(Boolean supportsLinking) {
            this.supportsLinking = supportsLinking;
        }

        public final String getEnablementType() {
            return this.enablementType;
        }

        @Override
        public final Builder enablementType(String enablementType) {
            this.enablementType = enablementType;
            return this;
        }

        @Override
        public final Builder enablementType(EnablementType enablementType) {
            this.enablementType(enablementType == null ? null : enablementType.toString());
            return this;
        }

        public final void setEnablementType(String enablementType) {
            this.enablementType = enablementType;
        }

        public final String getSkillType() {
            return this.skillType;
        }

        @Override
        public final Builder skillType(String skillType) {
            this.skillType = skillType;
            return this;
        }

        @Override
        public final Builder skillType(SkillType skillType) {
            this.skillType(skillType == null ? null : skillType.toString());
            return this;
        }

        public final void setSkillType(String skillType) {
            this.skillType = skillType;
        }

        public SkillSummary build() {
            return new SkillSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SkillSummary> {
        public Builder skillId(String var1);

        public Builder skillName(String var1);

        public Builder supportsLinking(Boolean var1);

        public Builder enablementType(String var1);

        public Builder enablementType(EnablementType var1);

        public Builder skillType(String var1);

        public Builder skillType(SkillType var1);
    }
}

