/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSkillAuthorizationRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<PutSkillAuthorizationRequest.Builder, PutSkillAuthorizationRequest> {
    private static final SdkField<Map<String, String>> AUTHORIZATION_RESULT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AuthorizationResult")
            .getter(getter(PutSkillAuthorizationRequest::authorizationResult))
            .setter(setter(Builder::authorizationResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationResult").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SKILL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SkillId").getter(getter(PutSkillAuthorizationRequest::skillId)).setter(setter(Builder::skillId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillId").build()).build();

    private static final SdkField<String> ROOM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoomArn").getter(getter(PutSkillAuthorizationRequest::roomArn)).setter(setter(Builder::roomArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_RESULT_FIELD,
            SKILL_ID_FIELD, ROOM_ARN_FIELD));

    private final Map<String, String> authorizationResult;

    private final String skillId;

    private final String roomArn;

    private PutSkillAuthorizationRequest(BuilderImpl builder) {
        super(builder);
        this.authorizationResult = builder.authorizationResult;
        this.skillId = builder.skillId;
        this.roomArn = builder.roomArn;
    }

    /**
     * Returns true if the AuthorizationResult property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAuthorizationResult() {
        return authorizationResult != null && !(authorizationResult instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The authorization result specific to OAUTH code grant output. "Code” must be populated in the AuthorizationResult
     * map to establish the authorization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAuthorizationResult()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The authorization result specific to OAUTH code grant output. "Code” must be populated in the
     *         AuthorizationResult map to establish the authorization.
     */
    public Map<String, String> authorizationResult() {
        return authorizationResult;
    }

    /**
     * <p>
     * The unique identifier of a skill.
     * </p>
     * 
     * @return The unique identifier of a skill.
     */
    public String skillId() {
        return skillId;
    }

    /**
     * <p>
     * The room that the skill is authorized for.
     * </p>
     * 
     * @return The room that the skill is authorized for.
     */
    public String roomArn() {
        return roomArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorizationResult() ? authorizationResult() : null);
        hashCode = 31 * hashCode + Objects.hashCode(skillId());
        hashCode = 31 * hashCode + Objects.hashCode(roomArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSkillAuthorizationRequest)) {
            return false;
        }
        PutSkillAuthorizationRequest other = (PutSkillAuthorizationRequest) obj;
        return hasAuthorizationResult() == other.hasAuthorizationResult()
                && Objects.equals(authorizationResult(), other.authorizationResult())
                && Objects.equals(skillId(), other.skillId()) && Objects.equals(roomArn(), other.roomArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutSkillAuthorizationRequest")
                .add("AuthorizationResult", authorizationResult() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SkillId", skillId()).add("RoomArn", roomArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthorizationResult":
            return Optional.ofNullable(clazz.cast(authorizationResult()));
        case "SkillId":
            return Optional.ofNullable(clazz.cast(skillId()));
        case "RoomArn":
            return Optional.ofNullable(clazz.cast(roomArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSkillAuthorizationRequest, T> g) {
        return obj -> g.apply((PutSkillAuthorizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutSkillAuthorizationRequest> {
        /**
         * <p>
         * The authorization result specific to OAUTH code grant output. "Code” must be populated in the
         * AuthorizationResult map to establish the authorization.
         * </p>
         * 
         * @param authorizationResult
         *        The authorization result specific to OAUTH code grant output. "Code” must be populated in the
         *        AuthorizationResult map to establish the authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationResult(Map<String, String> authorizationResult);

        /**
         * <p>
         * The unique identifier of a skill.
         * </p>
         * 
         * @param skillId
         *        The unique identifier of a skill.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillId(String skillId);

        /**
         * <p>
         * The room that the skill is authorized for.
         * </p>
         * 
         * @param roomArn
         *        The room that the skill is authorized for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomArn(String roomArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private Map<String, String> authorizationResult = DefaultSdkAutoConstructMap.getInstance();

        private String skillId;

        private String roomArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSkillAuthorizationRequest model) {
            super(model);
            authorizationResult(model.authorizationResult);
            skillId(model.skillId);
            roomArn(model.roomArn);
        }

        public final Map<String, String> getAuthorizationResult() {
            if (authorizationResult instanceof SdkAutoConstructMap) {
                return null;
            }
            return authorizationResult;
        }

        @Override
        public final Builder authorizationResult(Map<String, String> authorizationResult) {
            this.authorizationResult = AuthorizationResultCopier.copy(authorizationResult);
            return this;
        }

        public final void setAuthorizationResult(Map<String, String> authorizationResult) {
            this.authorizationResult = AuthorizationResultCopier.copy(authorizationResult);
        }

        public final String getSkillId() {
            return skillId;
        }

        @Override
        public final Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public final void setSkillId(String skillId) {
            this.skillId = skillId;
        }

        public final String getRoomArn() {
            return roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSkillAuthorizationRequest build() {
            return new PutSkillAuthorizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
