/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRoomSkillParameterRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<DeleteRoomSkillParameterRequest.Builder, DeleteRoomSkillParameterRequest> {
    private static final SdkField<String> ROOM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoomArn").getter(getter(DeleteRoomSkillParameterRequest::roomArn)).setter(setter(Builder::roomArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomArn").build()).build();

    private static final SdkField<String> SKILL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SkillId").getter(getter(DeleteRoomSkillParameterRequest::skillId)).setter(setter(Builder::skillId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillId").build()).build();

    private static final SdkField<String> PARAMETER_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterKey").getter(getter(DeleteRoomSkillParameterRequest::parameterKey))
            .setter(setter(Builder::parameterKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_ARN_FIELD,
            SKILL_ID_FIELD, PARAMETER_KEY_FIELD));

    private final String roomArn;

    private final String skillId;

    private final String parameterKey;

    private DeleteRoomSkillParameterRequest(BuilderImpl builder) {
        super(builder);
        this.roomArn = builder.roomArn;
        this.skillId = builder.skillId;
        this.parameterKey = builder.parameterKey;
    }

    /**
     * <p>
     * The ARN of the room from which to remove the room skill parameter details.
     * </p>
     * 
     * @return The ARN of the room from which to remove the room skill parameter details.
     */
    public String roomArn() {
        return roomArn;
    }

    /**
     * <p>
     * The ID of the skill from which to remove the room skill parameter details.
     * </p>
     * 
     * @return The ID of the skill from which to remove the room skill parameter details.
     */
    public String skillId() {
        return skillId;
    }

    /**
     * <p>
     * The room skill parameter key for which to remove details.
     * </p>
     * 
     * @return The room skill parameter key for which to remove details.
     */
    public String parameterKey() {
        return parameterKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(skillId());
        hashCode = 31 * hashCode + Objects.hashCode(parameterKey());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRoomSkillParameterRequest)) {
            return false;
        }
        DeleteRoomSkillParameterRequest other = (DeleteRoomSkillParameterRequest) obj;
        return Objects.equals(roomArn(), other.roomArn()) && Objects.equals(skillId(), other.skillId())
                && Objects.equals(parameterKey(), other.parameterKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteRoomSkillParameterRequest").add("RoomArn", roomArn()).add("SkillId", skillId())
                .add("ParameterKey", parameterKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoomArn":
            return Optional.ofNullable(clazz.cast(roomArn()));
        case "SkillId":
            return Optional.ofNullable(clazz.cast(skillId()));
        case "ParameterKey":
            return Optional.ofNullable(clazz.cast(parameterKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRoomSkillParameterRequest, T> g) {
        return obj -> g.apply((DeleteRoomSkillParameterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteRoomSkillParameterRequest> {
        /**
         * <p>
         * The ARN of the room from which to remove the room skill parameter details.
         * </p>
         * 
         * @param roomArn
         *        The ARN of the room from which to remove the room skill parameter details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomArn(String roomArn);

        /**
         * <p>
         * The ID of the skill from which to remove the room skill parameter details.
         * </p>
         * 
         * @param skillId
         *        The ID of the skill from which to remove the room skill parameter details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillId(String skillId);

        /**
         * <p>
         * The room skill parameter key for which to remove details.
         * </p>
         * 
         * @param parameterKey
         *        The room skill parameter key for which to remove details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterKey(String parameterKey);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String roomArn;

        private String skillId;

        private String parameterKey;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRoomSkillParameterRequest model) {
            super(model);
            roomArn(model.roomArn);
            skillId(model.skillId);
            parameterKey(model.parameterKey);
        }

        public final String getRoomArn() {
            return roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        public final String getSkillId() {
            return skillId;
        }

        @Override
        public final Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public final void setSkillId(String skillId) {
            this.skillId = skillId;
        }

        public final String getParameterKey() {
            return parameterKey;
        }

        @Override
        public final Builder parameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
            return this;
        }

        public final void setParameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRoomSkillParameterRequest build() {
            return new DeleteRoomSkillParameterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
