/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterAvsDeviceRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, RegisterAvsDeviceRequest> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientId").getter(RegisterAvsDeviceRequest.getter(RegisterAvsDeviceRequest::clientId)).setter(RegisterAvsDeviceRequest.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<String> USER_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserCode").getter(RegisterAvsDeviceRequest.getter(RegisterAvsDeviceRequest::userCode)).setter(RegisterAvsDeviceRequest.setter(Builder::userCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserCode").build()}).build();
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductId").getter(RegisterAvsDeviceRequest.getter(RegisterAvsDeviceRequest::productId)).setter(RegisterAvsDeviceRequest.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<String> DEVICE_SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceSerialNumber").getter(RegisterAvsDeviceRequest.getter(RegisterAvsDeviceRequest::deviceSerialNumber)).setter(RegisterAvsDeviceRequest.setter(Builder::deviceSerialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceSerialNumber").build()}).build();
    private static final SdkField<String> AMAZON_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmazonId").getter(RegisterAvsDeviceRequest.getter(RegisterAvsDeviceRequest::amazonId)).setter(RegisterAvsDeviceRequest.setter(Builder::amazonId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonId").build()}).build();
    private static final SdkField<String> ROOM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoomArn").getter(RegisterAvsDeviceRequest.getter(RegisterAvsDeviceRequest::roomArn)).setter(RegisterAvsDeviceRequest.setter(Builder::roomArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, USER_CODE_FIELD, PRODUCT_ID_FIELD, DEVICE_SERIAL_NUMBER_FIELD, AMAZON_ID_FIELD, ROOM_ARN_FIELD));
    private final String clientId;
    private final String userCode;
    private final String productId;
    private final String deviceSerialNumber;
    private final String amazonId;
    private final String roomArn;

    private RegisterAvsDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.userCode = builder.userCode;
        this.productId = builder.productId;
        this.deviceSerialNumber = builder.deviceSerialNumber;
        this.amazonId = builder.amazonId;
        this.roomArn = builder.roomArn;
    }

    public String clientId() {
        return this.clientId;
    }

    public String userCode() {
        return this.userCode;
    }

    public String productId() {
        return this.productId;
    }

    public String deviceSerialNumber() {
        return this.deviceSerialNumber;
    }

    public String amazonId() {
        return this.amazonId;
    }

    public String roomArn() {
        return this.roomArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceSerialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roomArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterAvsDeviceRequest)) {
            return false;
        }
        RegisterAvsDeviceRequest other = (RegisterAvsDeviceRequest)((Object)obj);
        return Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.userCode(), other.userCode()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.deviceSerialNumber(), other.deviceSerialNumber()) && Objects.equals(this.amazonId(), other.amazonId()) && Objects.equals(this.roomArn(), other.roomArn());
    }

    public String toString() {
        return ToString.builder((String)"RegisterAvsDeviceRequest").add("ClientId", (Object)this.clientId()).add("UserCode", (Object)this.userCode()).add("ProductId", (Object)this.productId()).add("DeviceSerialNumber", (Object)this.deviceSerialNumber()).add("AmazonId", (Object)this.amazonId()).add("RoomArn", (Object)this.roomArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "UserCode": {
                return Optional.ofNullable(clazz.cast(this.userCode()));
            }
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "DeviceSerialNumber": {
                return Optional.ofNullable(clazz.cast(this.deviceSerialNumber()));
            }
            case "AmazonId": {
                return Optional.ofNullable(clazz.cast(this.amazonId()));
            }
            case "RoomArn": {
                return Optional.ofNullable(clazz.cast(this.roomArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterAvsDeviceRequest, T> g) {
        return obj -> g.apply((RegisterAvsDeviceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String clientId;
        private String userCode;
        private String productId;
        private String deviceSerialNumber;
        private String amazonId;
        private String roomArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterAvsDeviceRequest model) {
            super(model);
            this.clientId(model.clientId);
            this.userCode(model.userCode);
            this.productId(model.productId);
            this.deviceSerialNumber(model.deviceSerialNumber);
            this.amazonId(model.amazonId);
            this.roomArn(model.roomArn);
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getUserCode() {
            return this.userCode;
        }

        @Override
        public final Builder userCode(String userCode) {
            this.userCode = userCode;
            return this;
        }

        public final void setUserCode(String userCode) {
            this.userCode = userCode;
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getDeviceSerialNumber() {
            return this.deviceSerialNumber;
        }

        @Override
        public final Builder deviceSerialNumber(String deviceSerialNumber) {
            this.deviceSerialNumber = deviceSerialNumber;
            return this;
        }

        public final void setDeviceSerialNumber(String deviceSerialNumber) {
            this.deviceSerialNumber = deviceSerialNumber;
        }

        public final String getAmazonId() {
            return this.amazonId;
        }

        @Override
        public final Builder amazonId(String amazonId) {
            this.amazonId = amazonId;
            return this;
        }

        public final void setAmazonId(String amazonId) {
            this.amazonId = amazonId;
        }

        public final String getRoomArn() {
            return this.roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterAvsDeviceRequest build() {
            return new RegisterAvsDeviceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterAvsDeviceRequest> {
        public Builder clientId(String var1);

        public Builder userCode(String var1);

        public Builder productId(String var1);

        public Builder deviceSerialNumber(String var1);

        public Builder amazonId(String var1);

        public Builder roomArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

