/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.EnablementTypeFilter;
import software.amazon.awssdk.services.alexaforbusiness.model.SkillTypeFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSkillsRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, ListSkillsRequest> {
    private static final SdkField<String> SKILL_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SkillGroupArn").getter(ListSkillsRequest.getter(ListSkillsRequest::skillGroupArn)).setter(ListSkillsRequest.setter(Builder::skillGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillGroupArn").build()}).build();
    private static final SdkField<String> ENABLEMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnablementType").getter(ListSkillsRequest.getter(ListSkillsRequest::enablementTypeAsString)).setter(ListSkillsRequest.setter(Builder::enablementType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablementType").build()}).build();
    private static final SdkField<String> SKILL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SkillType").getter(ListSkillsRequest.getter(ListSkillsRequest::skillTypeAsString)).setter(ListSkillsRequest.setter(Builder::skillType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillType").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSkillsRequest.getter(ListSkillsRequest::nextToken)).setter(ListSkillsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListSkillsRequest.getter(ListSkillsRequest::maxResults)).setter(ListSkillsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKILL_GROUP_ARN_FIELD, ENABLEMENT_TYPE_FIELD, SKILL_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String skillGroupArn;
    private final String enablementType;
    private final String skillType;
    private final String nextToken;
    private final Integer maxResults;

    private ListSkillsRequest(BuilderImpl builder) {
        super(builder);
        this.skillGroupArn = builder.skillGroupArn;
        this.enablementType = builder.enablementType;
        this.skillType = builder.skillType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String skillGroupArn() {
        return this.skillGroupArn;
    }

    public EnablementTypeFilter enablementType() {
        return EnablementTypeFilter.fromValue(this.enablementType);
    }

    public String enablementTypeAsString() {
        return this.enablementType;
    }

    public SkillTypeFilter skillType() {
        return SkillTypeFilter.fromValue(this.skillType);
    }

    public String skillTypeAsString() {
        return this.skillType;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.skillGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.skillTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSkillsRequest)) {
            return false;
        }
        ListSkillsRequest other = (ListSkillsRequest)((Object)obj);
        return Objects.equals(this.skillGroupArn(), other.skillGroupArn()) && Objects.equals(this.enablementTypeAsString(), other.enablementTypeAsString()) && Objects.equals(this.skillTypeAsString(), other.skillTypeAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"ListSkillsRequest").add("SkillGroupArn", (Object)this.skillGroupArn()).add("EnablementType", (Object)this.enablementTypeAsString()).add("SkillType", (Object)this.skillTypeAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SkillGroupArn": {
                return Optional.ofNullable(clazz.cast(this.skillGroupArn()));
            }
            case "EnablementType": {
                return Optional.ofNullable(clazz.cast(this.enablementTypeAsString()));
            }
            case "SkillType": {
                return Optional.ofNullable(clazz.cast(this.skillTypeAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSkillsRequest, T> g) {
        return obj -> g.apply((ListSkillsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String skillGroupArn;
        private String enablementType;
        private String skillType;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSkillsRequest model) {
            super(model);
            this.skillGroupArn(model.skillGroupArn);
            this.enablementType(model.enablementType);
            this.skillType(model.skillType);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getSkillGroupArn() {
            return this.skillGroupArn;
        }

        @Override
        public final Builder skillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
            return this;
        }

        public final void setSkillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
        }

        public final String getEnablementType() {
            return this.enablementType;
        }

        @Override
        public final Builder enablementType(String enablementType) {
            this.enablementType = enablementType;
            return this;
        }

        @Override
        public final Builder enablementType(EnablementTypeFilter enablementType) {
            this.enablementType(enablementType == null ? null : enablementType.toString());
            return this;
        }

        public final void setEnablementType(String enablementType) {
            this.enablementType = enablementType;
        }

        public final String getSkillType() {
            return this.skillType;
        }

        @Override
        public final Builder skillType(String skillType) {
            this.skillType = skillType;
            return this;
        }

        @Override
        public final Builder skillType(SkillTypeFilter skillType) {
            this.skillType(skillType == null ? null : skillType.toString());
            return this;
        }

        public final void setSkillType(String skillType) {
            this.skillType = skillType;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSkillsRequest build() {
            return new ListSkillsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSkillsRequest> {
        public Builder skillGroupArn(String var1);

        public Builder enablementType(String var1);

        public Builder enablementType(EnablementTypeFilter var1);

        public Builder skillType(String var1);

        public Builder skillType(SkillTypeFilter var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

