/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.NetworkProfileData;
import software.amazon.awssdk.services.alexaforbusiness.model.NetworkProfileDataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchNetworkProfilesResponse
extends AlexaForBusinessResponse
implements ToCopyableBuilder<Builder, SearchNetworkProfilesResponse> {
    private static final SdkField<List<NetworkProfileData>> NETWORK_PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkProfiles").getter(SearchNetworkProfilesResponse.getter(SearchNetworkProfilesResponse::networkProfiles)).setter(SearchNetworkProfilesResponse.setter(Builder::networkProfiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkProfiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkProfileData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchNetworkProfilesResponse.getter(SearchNetworkProfilesResponse::nextToken)).setter(SearchNetworkProfilesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalCount").getter(SearchNetworkProfilesResponse.getter(SearchNetworkProfilesResponse::totalCount)).setter(SearchNetworkProfilesResponse.setter(Builder::totalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_PROFILES_FIELD, NEXT_TOKEN_FIELD, TOTAL_COUNT_FIELD));
    private final List<NetworkProfileData> networkProfiles;
    private final String nextToken;
    private final Integer totalCount;

    private SearchNetworkProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.networkProfiles = builder.networkProfiles;
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
    }

    public boolean hasNetworkProfiles() {
        return this.networkProfiles != null && !(this.networkProfiles instanceof SdkAutoConstructList);
    }

    public List<NetworkProfileData> networkProfiles() {
        return this.networkProfiles;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer totalCount() {
        return this.totalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkProfiles() ? this.networkProfiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchNetworkProfilesResponse)) {
            return false;
        }
        SearchNetworkProfilesResponse other = (SearchNetworkProfilesResponse)((Object)obj);
        return this.hasNetworkProfiles() == other.hasNetworkProfiles() && Objects.equals(this.networkProfiles(), other.networkProfiles()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.totalCount(), other.totalCount());
    }

    public String toString() {
        return ToString.builder((String)"SearchNetworkProfilesResponse").add("NetworkProfiles", this.hasNetworkProfiles() ? this.networkProfiles() : null).add("NextToken", (Object)this.nextToken()).add("TotalCount", (Object)this.totalCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkProfiles": {
                return Optional.ofNullable(clazz.cast(this.networkProfiles()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TotalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchNetworkProfilesResponse, T> g) {
        return obj -> g.apply((SearchNetworkProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessResponse.BuilderImpl
    implements Builder {
        private List<NetworkProfileData> networkProfiles = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchNetworkProfilesResponse model) {
            super(model);
            this.networkProfiles(model.networkProfiles);
            this.nextToken(model.nextToken);
            this.totalCount(model.totalCount);
        }

        public final Collection<NetworkProfileData.Builder> getNetworkProfiles() {
            if (this.networkProfiles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.networkProfiles != null ? (Collection)this.networkProfiles.stream().map(NetworkProfileData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkProfiles(Collection<NetworkProfileData> networkProfiles) {
            this.networkProfiles = NetworkProfileDataListCopier.copy(networkProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkProfiles(NetworkProfileData ... networkProfiles) {
            this.networkProfiles(Arrays.asList(networkProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkProfiles(Consumer<NetworkProfileData.Builder> ... networkProfiles) {
            this.networkProfiles(Stream.of(networkProfiles).map(c -> (NetworkProfileData)((NetworkProfileData.Builder)NetworkProfileData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkProfiles(Collection<NetworkProfileData.BuilderImpl> networkProfiles) {
            this.networkProfiles = NetworkProfileDataListCopier.copyFromBuilder(networkProfiles);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getTotalCount() {
            return this.totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public SearchNetworkProfilesResponse build() {
            return new SearchNetworkProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchNetworkProfilesResponse> {
        public Builder networkProfiles(Collection<NetworkProfileData> var1);

        public Builder networkProfiles(NetworkProfileData ... var1);

        public Builder networkProfiles(Consumer<NetworkProfileData.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder totalCount(Integer var1);
    }
}

