/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.Feature;
import software.amazon.awssdk.services.alexaforbusiness.model.FeaturesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDeviceSyncRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, StartDeviceSyncRequest> {
    private static final SdkField<String> ROOM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoomArn").getter(StartDeviceSyncRequest.getter(StartDeviceSyncRequest::roomArn)).setter(StartDeviceSyncRequest.setter(Builder::roomArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomArn").build()}).build();
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceArn").getter(StartDeviceSyncRequest.getter(StartDeviceSyncRequest::deviceArn)).setter(StartDeviceSyncRequest.setter(Builder::deviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceArn").build()}).build();
    private static final SdkField<List<String>> FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Features").getter(StartDeviceSyncRequest.getter(StartDeviceSyncRequest::featuresAsStrings)).setter(StartDeviceSyncRequest.setter(Builder::featuresWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Features").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_ARN_FIELD, DEVICE_ARN_FIELD, FEATURES_FIELD));
    private final String roomArn;
    private final String deviceArn;
    private final List<String> features;

    private StartDeviceSyncRequest(BuilderImpl builder) {
        super(builder);
        this.roomArn = builder.roomArn;
        this.deviceArn = builder.deviceArn;
        this.features = builder.features;
    }

    public String roomArn() {
        return this.roomArn;
    }

    public String deviceArn() {
        return this.deviceArn;
    }

    public List<Feature> features() {
        return FeaturesCopier.copyStringToEnum(this.features);
    }

    public boolean hasFeatures() {
        return this.features != null && !(this.features instanceof SdkAutoConstructList);
    }

    public List<String> featuresAsStrings() {
        return this.features;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.featuresAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDeviceSyncRequest)) {
            return false;
        }
        StartDeviceSyncRequest other = (StartDeviceSyncRequest)((Object)obj);
        return Objects.equals(this.roomArn(), other.roomArn()) && Objects.equals(this.deviceArn(), other.deviceArn()) && Objects.equals(this.featuresAsStrings(), other.featuresAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"StartDeviceSyncRequest").add("RoomArn", (Object)this.roomArn()).add("DeviceArn", (Object)this.deviceArn()).add("Features", this.featuresAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoomArn": {
                return Optional.ofNullable(clazz.cast(this.roomArn()));
            }
            case "DeviceArn": {
                return Optional.ofNullable(clazz.cast(this.deviceArn()));
            }
            case "Features": {
                return Optional.ofNullable(clazz.cast(this.featuresAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDeviceSyncRequest, T> g) {
        return obj -> g.apply((StartDeviceSyncRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String roomArn;
        private String deviceArn;
        private List<String> features = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartDeviceSyncRequest model) {
            super(model);
            this.roomArn(model.roomArn);
            this.deviceArn(model.deviceArn);
            this.featuresWithStrings(model.features);
        }

        public final String getRoomArn() {
            return this.roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final Collection<String> getFeatures() {
            return this.features;
        }

        @Override
        public final Builder featuresWithStrings(Collection<String> features) {
            this.features = FeaturesCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuresWithStrings(String ... features) {
            this.featuresWithStrings(Arrays.asList(features));
            return this;
        }

        @Override
        public final Builder features(Collection<Feature> features) {
            this.features = FeaturesCopier.copyEnumToString(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(Feature ... features) {
            this.features(Arrays.asList(features));
            return this;
        }

        public final void setFeatures(Collection<String> features) {
            this.features = FeaturesCopier.copy(features);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDeviceSyncRequest build() {
            return new StartDeviceSyncRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDeviceSyncRequest> {
        public Builder roomArn(String var1);

        public Builder deviceArn(String var1);

        public Builder featuresWithStrings(Collection<String> var1);

        public Builder featuresWithStrings(String ... var1);

        public Builder features(Collection<Feature> var1);

        public Builder features(Feature ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

