/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFormat;
import software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportRecurrence;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBusinessReportScheduleRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, UpdateBusinessReportScheduleRequest> {
    private static final SdkField<String> SCHEDULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleArn").getter(UpdateBusinessReportScheduleRequest.getter(UpdateBusinessReportScheduleRequest::scheduleArn)).setter(UpdateBusinessReportScheduleRequest.setter(Builder::scheduleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleArn").build()}).build();
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(UpdateBusinessReportScheduleRequest.getter(UpdateBusinessReportScheduleRequest::s3BucketName)).setter(UpdateBusinessReportScheduleRequest.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3KeyPrefix").getter(UpdateBusinessReportScheduleRequest.getter(UpdateBusinessReportScheduleRequest::s3KeyPrefix)).setter(UpdateBusinessReportScheduleRequest.setter(Builder::s3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(UpdateBusinessReportScheduleRequest.getter(UpdateBusinessReportScheduleRequest::formatAsString)).setter(UpdateBusinessReportScheduleRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final SdkField<String> SCHEDULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleName").getter(UpdateBusinessReportScheduleRequest.getter(UpdateBusinessReportScheduleRequest::scheduleName)).setter(UpdateBusinessReportScheduleRequest.setter(Builder::scheduleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleName").build()}).build();
    private static final SdkField<BusinessReportRecurrence> RECURRENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Recurrence").getter(UpdateBusinessReportScheduleRequest.getter(UpdateBusinessReportScheduleRequest::recurrence)).setter(UpdateBusinessReportScheduleRequest.setter(Builder::recurrence)).constructor(BusinessReportRecurrence::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recurrence").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_ARN_FIELD, S3_BUCKET_NAME_FIELD, S3_KEY_PREFIX_FIELD, FORMAT_FIELD, SCHEDULE_NAME_FIELD, RECURRENCE_FIELD));
    private final String scheduleArn;
    private final String s3BucketName;
    private final String s3KeyPrefix;
    private final String format;
    private final String scheduleName;
    private final BusinessReportRecurrence recurrence;

    private UpdateBusinessReportScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.scheduleArn = builder.scheduleArn;
        this.s3BucketName = builder.s3BucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.format = builder.format;
        this.scheduleName = builder.scheduleName;
        this.recurrence = builder.recurrence;
    }

    public String scheduleArn() {
        return this.scheduleArn;
    }

    public String s3BucketName() {
        return this.s3BucketName;
    }

    public String s3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public BusinessReportFormat format() {
        return BusinessReportFormat.fromValue(this.format);
    }

    public String formatAsString() {
        return this.format;
    }

    public String scheduleName() {
        return this.scheduleName;
    }

    public BusinessReportRecurrence recurrence() {
        return this.recurrence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurrence());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBusinessReportScheduleRequest)) {
            return false;
        }
        UpdateBusinessReportScheduleRequest other = (UpdateBusinessReportScheduleRequest)((Object)obj);
        return Objects.equals(this.scheduleArn(), other.scheduleArn()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.s3KeyPrefix(), other.s3KeyPrefix()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.scheduleName(), other.scheduleName()) && Objects.equals(this.recurrence(), other.recurrence());
    }

    public String toString() {
        return ToString.builder((String)"UpdateBusinessReportScheduleRequest").add("ScheduleArn", (Object)this.scheduleArn()).add("S3BucketName", (Object)this.s3BucketName()).add("S3KeyPrefix", (Object)this.s3KeyPrefix()).add("Format", (Object)this.formatAsString()).add("ScheduleName", (Object)this.scheduleName()).add("Recurrence", (Object)this.recurrence()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduleArn": {
                return Optional.ofNullable(clazz.cast(this.scheduleArn()));
            }
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "S3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.s3KeyPrefix()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "ScheduleName": {
                return Optional.ofNullable(clazz.cast(this.scheduleName()));
            }
            case "Recurrence": {
                return Optional.ofNullable(clazz.cast(this.recurrence()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBusinessReportScheduleRequest, T> g) {
        return obj -> g.apply((UpdateBusinessReportScheduleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String scheduleArn;
        private String s3BucketName;
        private String s3KeyPrefix;
        private String format;
        private String scheduleName;
        private BusinessReportRecurrence recurrence;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBusinessReportScheduleRequest model) {
            super(model);
            this.scheduleArn(model.scheduleArn);
            this.s3BucketName(model.s3BucketName);
            this.s3KeyPrefix(model.s3KeyPrefix);
            this.format(model.format);
            this.scheduleName(model.scheduleName);
            this.recurrence(model.recurrence);
        }

        public final String getScheduleArn() {
            return this.scheduleArn;
        }

        @Override
        public final Builder scheduleArn(String scheduleArn) {
            this.scheduleArn = scheduleArn;
            return this;
        }

        public final void setScheduleArn(String scheduleArn) {
            this.scheduleArn = scheduleArn;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(BusinessReportFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getScheduleName() {
            return this.scheduleName;
        }

        @Override
        public final Builder scheduleName(String scheduleName) {
            this.scheduleName = scheduleName;
            return this;
        }

        public final void setScheduleName(String scheduleName) {
            this.scheduleName = scheduleName;
        }

        public final BusinessReportRecurrence.Builder getRecurrence() {
            return this.recurrence != null ? this.recurrence.toBuilder() : null;
        }

        @Override
        public final Builder recurrence(BusinessReportRecurrence recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final void setRecurrence(BusinessReportRecurrence.BuilderImpl recurrence) {
            this.recurrence = recurrence != null ? recurrence.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBusinessReportScheduleRequest build() {
            return new UpdateBusinessReportScheduleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBusinessReportScheduleRequest> {
        public Builder scheduleArn(String var1);

        public Builder s3BucketName(String var1);

        public Builder s3KeyPrefix(String var1);

        public Builder format(String var1);

        public Builder format(BusinessReportFormat var1);

        public Builder scheduleName(String var1);

        public Builder recurrence(BusinessReportRecurrence var1);

        default public Builder recurrence(Consumer<BusinessReportRecurrence.Builder> recurrence) {
            return this.recurrence((BusinessReportRecurrence)((BusinessReportRecurrence.Builder)BusinessReportRecurrence.builder().applyMutation(recurrence)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

