/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GatewayGroupSummariesCopier;
import software.amazon.awssdk.services.alexaforbusiness.model.GatewayGroupSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGatewayGroupsResponse
extends AlexaForBusinessResponse
implements ToCopyableBuilder<Builder, ListGatewayGroupsResponse> {
    private static final SdkField<List<GatewayGroupSummary>> GATEWAY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GatewayGroups").getter(ListGatewayGroupsResponse.getter(ListGatewayGroupsResponse::gatewayGroups)).setter(ListGatewayGroupsResponse.setter(Builder::gatewayGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GatewayGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListGatewayGroupsResponse.getter(ListGatewayGroupsResponse::nextToken)).setter(ListGatewayGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<GatewayGroupSummary> gatewayGroups;
    private final String nextToken;

    private ListGatewayGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayGroups = builder.gatewayGroups;
        this.nextToken = builder.nextToken;
    }

    public boolean hasGatewayGroups() {
        return this.gatewayGroups != null && !(this.gatewayGroups instanceof SdkAutoConstructList);
    }

    public List<GatewayGroupSummary> gatewayGroups() {
        return this.gatewayGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGatewayGroups() ? this.gatewayGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGatewayGroupsResponse)) {
            return false;
        }
        ListGatewayGroupsResponse other = (ListGatewayGroupsResponse)((Object)obj);
        return this.hasGatewayGroups() == other.hasGatewayGroups() && Objects.equals(this.gatewayGroups(), other.gatewayGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListGatewayGroupsResponse").add("GatewayGroups", this.hasGatewayGroups() ? this.gatewayGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayGroups": {
                return Optional.ofNullable(clazz.cast(this.gatewayGroups()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGatewayGroupsResponse, T> g) {
        return obj -> g.apply((ListGatewayGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessResponse.BuilderImpl
    implements Builder {
        private List<GatewayGroupSummary> gatewayGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGatewayGroupsResponse model) {
            super(model);
            this.gatewayGroups(model.gatewayGroups);
            this.nextToken(model.nextToken);
        }

        public final Collection<GatewayGroupSummary.Builder> getGatewayGroups() {
            if (this.gatewayGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.gatewayGroups != null ? (Collection)this.gatewayGroups.stream().map(GatewayGroupSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gatewayGroups(Collection<GatewayGroupSummary> gatewayGroups) {
            this.gatewayGroups = GatewayGroupSummariesCopier.copy(gatewayGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayGroups(GatewayGroupSummary ... gatewayGroups) {
            this.gatewayGroups(Arrays.asList(gatewayGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayGroups(Consumer<GatewayGroupSummary.Builder> ... gatewayGroups) {
            this.gatewayGroups(Stream.of(gatewayGroups).map(c -> (GatewayGroupSummary)((GatewayGroupSummary.Builder)GatewayGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGatewayGroups(Collection<GatewayGroupSummary.BuilderImpl> gatewayGroups) {
            this.gatewayGroups = GatewayGroupSummariesCopier.copyFromBuilder(gatewayGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListGatewayGroupsResponse build() {
            return new ListGatewayGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGatewayGroupsResponse> {
        public Builder gatewayGroups(Collection<GatewayGroupSummary> var1);

        public Builder gatewayGroups(GatewayGroupSummary ... var1);

        public Builder gatewayGroups(Consumer<GatewayGroupSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

