/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information for public switched telephone network (PSTN) conferencing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PSTNDialIn implements SdkPojo, Serializable, ToCopyableBuilder<PSTNDialIn.Builder, PSTNDialIn> {
    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CountryCode").getter(getter(PSTNDialIn::countryCode)).setter(setter(Builder::countryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCode").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(PSTNDialIn::phoneNumber)).setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<String> ONE_CLICK_ID_DELAY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OneClickIdDelay").getter(getter(PSTNDialIn::oneClickIdDelay)).setter(setter(Builder::oneClickIdDelay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OneClickIdDelay").build()).build();

    private static final SdkField<String> ONE_CLICK_PIN_DELAY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OneClickPinDelay").getter(getter(PSTNDialIn::oneClickPinDelay))
            .setter(setter(Builder::oneClickPinDelay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OneClickPinDelay").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_CODE_FIELD,
            PHONE_NUMBER_FIELD, ONE_CLICK_ID_DELAY_FIELD, ONE_CLICK_PIN_DELAY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String countryCode;

    private final String phoneNumber;

    private final String oneClickIdDelay;

    private final String oneClickPinDelay;

    private PSTNDialIn(BuilderImpl builder) {
        this.countryCode = builder.countryCode;
        this.phoneNumber = builder.phoneNumber;
        this.oneClickIdDelay = builder.oneClickIdDelay;
        this.oneClickPinDelay = builder.oneClickPinDelay;
    }

    /**
     * <p>
     * The zip code.
     * </p>
     * 
     * @return The zip code.
     */
    public String countryCode() {
        return countryCode;
    }

    /**
     * <p>
     * The phone number to call to join the conference.
     * </p>
     * 
     * @return The phone number to call to join the conference.
     */
    public String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * The delay duration before Alexa enters the conference ID with dual-tone multi-frequency (DTMF). Each number on
     * the dial pad corresponds to a DTMF tone, which is how we send data over the telephone network.
     * </p>
     * 
     * @return The delay duration before Alexa enters the conference ID with dual-tone multi-frequency (DTMF). Each
     *         number on the dial pad corresponds to a DTMF tone, which is how we send data over the telephone network.
     */
    public String oneClickIdDelay() {
        return oneClickIdDelay;
    }

    /**
     * <p>
     * The delay duration before Alexa enters the conference pin with dual-tone multi-frequency (DTMF). Each number on
     * the dial pad corresponds to a DTMF tone, which is how we send data over the telephone network.
     * </p>
     * 
     * @return The delay duration before Alexa enters the conference pin with dual-tone multi-frequency (DTMF). Each
     *         number on the dial pad corresponds to a DTMF tone, which is how we send data over the telephone network.
     */
    public String oneClickPinDelay() {
        return oneClickPinDelay;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(oneClickIdDelay());
        hashCode = 31 * hashCode + Objects.hashCode(oneClickPinDelay());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PSTNDialIn)) {
            return false;
        }
        PSTNDialIn other = (PSTNDialIn) obj;
        return Objects.equals(countryCode(), other.countryCode()) && Objects.equals(phoneNumber(), other.phoneNumber())
                && Objects.equals(oneClickIdDelay(), other.oneClickIdDelay())
                && Objects.equals(oneClickPinDelay(), other.oneClickPinDelay());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PSTNDialIn").add("CountryCode", countryCode()).add("PhoneNumber", phoneNumber())
                .add("OneClickIdDelay", oneClickIdDelay()).add("OneClickPinDelay", oneClickPinDelay()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CountryCode":
            return Optional.ofNullable(clazz.cast(countryCode()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "OneClickIdDelay":
            return Optional.ofNullable(clazz.cast(oneClickIdDelay()));
        case "OneClickPinDelay":
            return Optional.ofNullable(clazz.cast(oneClickPinDelay()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PSTNDialIn, T> g) {
        return obj -> g.apply((PSTNDialIn) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PSTNDialIn> {
        /**
         * <p>
         * The zip code.
         * </p>
         * 
         * @param countryCode
         *        The zip code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryCode(String countryCode);

        /**
         * <p>
         * The phone number to call to join the conference.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number to call to join the conference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * The delay duration before Alexa enters the conference ID with dual-tone multi-frequency (DTMF). Each number
         * on the dial pad corresponds to a DTMF tone, which is how we send data over the telephone network.
         * </p>
         * 
         * @param oneClickIdDelay
         *        The delay duration before Alexa enters the conference ID with dual-tone multi-frequency (DTMF). Each
         *        number on the dial pad corresponds to a DTMF tone, which is how we send data over the telephone
         *        network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oneClickIdDelay(String oneClickIdDelay);

        /**
         * <p>
         * The delay duration before Alexa enters the conference pin with dual-tone multi-frequency (DTMF). Each number
         * on the dial pad corresponds to a DTMF tone, which is how we send data over the telephone network.
         * </p>
         * 
         * @param oneClickPinDelay
         *        The delay duration before Alexa enters the conference pin with dual-tone multi-frequency (DTMF). Each
         *        number on the dial pad corresponds to a DTMF tone, which is how we send data over the telephone
         *        network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oneClickPinDelay(String oneClickPinDelay);
    }

    static final class BuilderImpl implements Builder {
        private String countryCode;

        private String phoneNumber;

        private String oneClickIdDelay;

        private String oneClickPinDelay;

        private BuilderImpl() {
        }

        private BuilderImpl(PSTNDialIn model) {
            countryCode(model.countryCode);
            phoneNumber(model.phoneNumber);
            oneClickIdDelay(model.oneClickIdDelay);
            oneClickPinDelay(model.oneClickPinDelay);
        }

        public final String getCountryCode() {
            return countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public final String getOneClickIdDelay() {
            return oneClickIdDelay;
        }

        @Override
        public final Builder oneClickIdDelay(String oneClickIdDelay) {
            this.oneClickIdDelay = oneClickIdDelay;
            return this;
        }

        public final void setOneClickIdDelay(String oneClickIdDelay) {
            this.oneClickIdDelay = oneClickIdDelay;
        }

        public final String getOneClickPinDelay() {
            return oneClickPinDelay;
        }

        @Override
        public final Builder oneClickPinDelay(String oneClickPinDelay) {
            this.oneClickPinDelay = oneClickPinDelay;
            return this;
        }

        public final void setOneClickPinDelay(String oneClickPinDelay) {
            this.oneClickPinDelay = oneClickPinDelay;
        }

        @Override
        public PSTNDialIn build() {
            return new PSTNDialIn(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
