/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates settings for the require check in feature that are applied to a room profile. Require check in allows a
 * meeting room’s Alexa or AVS device to prompt the user to check in; otherwise, the room will be released.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRequireCheckIn implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateRequireCheckIn.Builder, UpdateRequireCheckIn> {
    private static final SdkField<Integer> RELEASE_AFTER_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReleaseAfterMinutes").getter(getter(UpdateRequireCheckIn::releaseAfterMinutes))
            .setter(setter(Builder::releaseAfterMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseAfterMinutes").build())
            .build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(UpdateRequireCheckIn::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELEASE_AFTER_MINUTES_FIELD,
            ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer releaseAfterMinutes;

    private final Boolean enabled;

    private UpdateRequireCheckIn(BuilderImpl builder) {
        this.releaseAfterMinutes = builder.releaseAfterMinutes;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * Duration between 5 and 20 minutes to determine when to release the room if it's not checked into.
     * </p>
     * 
     * @return Duration between 5 and 20 minutes to determine when to release the room if it's not checked into.
     */
    public Integer releaseAfterMinutes() {
        return releaseAfterMinutes;
    }

    /**
     * <p>
     * Whether require check in is enabled or not.
     * </p>
     * 
     * @return Whether require check in is enabled or not.
     */
    public Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(releaseAfterMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRequireCheckIn)) {
            return false;
        }
        UpdateRequireCheckIn other = (UpdateRequireCheckIn) obj;
        return Objects.equals(releaseAfterMinutes(), other.releaseAfterMinutes()) && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateRequireCheckIn").add("ReleaseAfterMinutes", releaseAfterMinutes())
                .add("Enabled", enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReleaseAfterMinutes":
            return Optional.ofNullable(clazz.cast(releaseAfterMinutes()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRequireCheckIn, T> g) {
        return obj -> g.apply((UpdateRequireCheckIn) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateRequireCheckIn> {
        /**
         * <p>
         * Duration between 5 and 20 minutes to determine when to release the room if it's not checked into.
         * </p>
         * 
         * @param releaseAfterMinutes
         *        Duration between 5 and 20 minutes to determine when to release the room if it's not checked into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseAfterMinutes(Integer releaseAfterMinutes);

        /**
         * <p>
         * Whether require check in is enabled or not.
         * </p>
         * 
         * @param enabled
         *        Whether require check in is enabled or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private Integer releaseAfterMinutes;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRequireCheckIn model) {
            releaseAfterMinutes(model.releaseAfterMinutes);
            enabled(model.enabled);
        }

        public final Integer getReleaseAfterMinutes() {
            return releaseAfterMinutes;
        }

        @Override
        public final Builder releaseAfterMinutes(Integer releaseAfterMinutes) {
            this.releaseAfterMinutes = releaseAfterMinutes;
            return this;
        }

        public final void setReleaseAfterMinutes(Integer releaseAfterMinutes) {
            this.releaseAfterMinutes = releaseAfterMinutes;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public UpdateRequireCheckIn build() {
            return new UpdateRequireCheckIn(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
