/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data associated with a network profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkProfileData implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkProfileData.Builder, NetworkProfileData> {
    private static final SdkField<String> NETWORK_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkProfileArn").getter(getter(NetworkProfileData::networkProfileArn))
            .setter(setter(Builder::networkProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkProfileArn").build()).build();

    private static final SdkField<String> NETWORK_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkProfileName").getter(getter(NetworkProfileData::networkProfileName))
            .setter(setter(Builder::networkProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkProfileName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(NetworkProfileData::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SSID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Ssid")
            .getter(getter(NetworkProfileData::ssid)).setter(setter(Builder::ssid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ssid").build()).build();

    private static final SdkField<String> SECURITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityType").getter(getter(NetworkProfileData::securityTypeAsString))
            .setter(setter(Builder::securityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityType").build()).build();

    private static final SdkField<String> EAP_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EapMethod").getter(getter(NetworkProfileData::eapMethodAsString)).setter(setter(Builder::eapMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EapMethod").build()).build();

    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateAuthorityArn").getter(getter(NetworkProfileData::certificateAuthorityArn))
            .setter(setter(Builder::certificateAuthorityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_PROFILE_ARN_FIELD,
            NETWORK_PROFILE_NAME_FIELD, DESCRIPTION_FIELD, SSID_FIELD, SECURITY_TYPE_FIELD, EAP_METHOD_FIELD,
            CERTIFICATE_AUTHORITY_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String networkProfileArn;

    private final String networkProfileName;

    private final String description;

    private final String ssid;

    private final String securityType;

    private final String eapMethod;

    private final String certificateAuthorityArn;

    private NetworkProfileData(BuilderImpl builder) {
        this.networkProfileArn = builder.networkProfileArn;
        this.networkProfileName = builder.networkProfileName;
        this.description = builder.description;
        this.ssid = builder.ssid;
        this.securityType = builder.securityType;
        this.eapMethod = builder.eapMethod;
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
    }

    /**
     * <p>
     * The ARN of the network profile associated with a device.
     * </p>
     * 
     * @return The ARN of the network profile associated with a device.
     */
    public String networkProfileArn() {
        return networkProfileArn;
    }

    /**
     * <p>
     * The name of the network profile associated with a device.
     * </p>
     * 
     * @return The name of the network profile associated with a device.
     */
    public String networkProfileName() {
        return networkProfileName;
    }

    /**
     * <p>
     * Detailed information about a device's network profile.
     * </p>
     * 
     * @return Detailed information about a device's network profile.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The SSID of the Wi-Fi network.
     * </p>
     * 
     * @return The SSID of the Wi-Fi network.
     */
    public String ssid() {
        return ssid;
    }

    /**
     * <p>
     * The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK, WEP, or OPEN.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #securityType} will
     * return {@link NetworkSecurityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #securityTypeAsString}.
     * </p>
     * 
     * @return The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK, WEP, or OPEN.
     * @see NetworkSecurityType
     */
    public NetworkSecurityType securityType() {
        return NetworkSecurityType.fromValue(securityType);
    }

    /**
     * <p>
     * The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK, WEP, or OPEN.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #securityType} will
     * return {@link NetworkSecurityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #securityTypeAsString}.
     * </p>
     * 
     * @return The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK, WEP, or OPEN.
     * @see NetworkSecurityType
     */
    public String securityTypeAsString() {
        return securityType;
    }

    /**
     * <p>
     * The authentication standard that is used in the EAP framework. Currently, EAP_TLS is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eapMethod} will
     * return {@link NetworkEapMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eapMethodAsString}.
     * </p>
     * 
     * @return The authentication standard that is used in the EAP framework. Currently, EAP_TLS is supported.
     * @see NetworkEapMethod
     */
    public NetworkEapMethod eapMethod() {
        return NetworkEapMethod.fromValue(eapMethod);
    }

    /**
     * <p>
     * The authentication standard that is used in the EAP framework. Currently, EAP_TLS is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eapMethod} will
     * return {@link NetworkEapMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eapMethodAsString}.
     * </p>
     * 
     * @return The authentication standard that is used in the EAP framework. Currently, EAP_TLS is supported.
     * @see NetworkEapMethod
     */
    public String eapMethodAsString() {
        return eapMethod;
    }

    /**
     * <p>
     * The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager (ACM). This is used to
     * issue certificates to the devices.
     * </p>
     * 
     * @return The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager (ACM). This is used
     *         to issue certificates to the devices.
     */
    public String certificateAuthorityArn() {
        return certificateAuthorityArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(ssid());
        hashCode = 31 * hashCode + Objects.hashCode(securityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eapMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(certificateAuthorityArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkProfileData)) {
            return false;
        }
        NetworkProfileData other = (NetworkProfileData) obj;
        return Objects.equals(networkProfileArn(), other.networkProfileArn())
                && Objects.equals(networkProfileName(), other.networkProfileName())
                && Objects.equals(description(), other.description()) && Objects.equals(ssid(), other.ssid())
                && Objects.equals(securityTypeAsString(), other.securityTypeAsString())
                && Objects.equals(eapMethodAsString(), other.eapMethodAsString())
                && Objects.equals(certificateAuthorityArn(), other.certificateAuthorityArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NetworkProfileData").add("NetworkProfileArn", networkProfileArn())
                .add("NetworkProfileName", networkProfileName()).add("Description", description()).add("Ssid", ssid())
                .add("SecurityType", securityTypeAsString()).add("EapMethod", eapMethodAsString())
                .add("CertificateAuthorityArn", certificateAuthorityArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkProfileArn":
            return Optional.ofNullable(clazz.cast(networkProfileArn()));
        case "NetworkProfileName":
            return Optional.ofNullable(clazz.cast(networkProfileName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Ssid":
            return Optional.ofNullable(clazz.cast(ssid()));
        case "SecurityType":
            return Optional.ofNullable(clazz.cast(securityTypeAsString()));
        case "EapMethod":
            return Optional.ofNullable(clazz.cast(eapMethodAsString()));
        case "CertificateAuthorityArn":
            return Optional.ofNullable(clazz.cast(certificateAuthorityArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkProfileData, T> g) {
        return obj -> g.apply((NetworkProfileData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkProfileData> {
        /**
         * <p>
         * The ARN of the network profile associated with a device.
         * </p>
         * 
         * @param networkProfileArn
         *        The ARN of the network profile associated with a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProfileArn(String networkProfileArn);

        /**
         * <p>
         * The name of the network profile associated with a device.
         * </p>
         * 
         * @param networkProfileName
         *        The name of the network profile associated with a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkProfileName(String networkProfileName);

        /**
         * <p>
         * Detailed information about a device's network profile.
         * </p>
         * 
         * @param description
         *        Detailed information about a device's network profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The SSID of the Wi-Fi network.
         * </p>
         * 
         * @param ssid
         *        The SSID of the Wi-Fi network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssid(String ssid);

        /**
         * <p>
         * The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK, WEP, or OPEN.
         * </p>
         * 
         * @param securityType
         *        The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK, WEP, or OPEN.
         * @see NetworkSecurityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkSecurityType
         */
        Builder securityType(String securityType);

        /**
         * <p>
         * The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK, WEP, or OPEN.
         * </p>
         * 
         * @param securityType
         *        The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK, WEP, or OPEN.
         * @see NetworkSecurityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkSecurityType
         */
        Builder securityType(NetworkSecurityType securityType);

        /**
         * <p>
         * The authentication standard that is used in the EAP framework. Currently, EAP_TLS is supported.
         * </p>
         * 
         * @param eapMethod
         *        The authentication standard that is used in the EAP framework. Currently, EAP_TLS is supported.
         * @see NetworkEapMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkEapMethod
         */
        Builder eapMethod(String eapMethod);

        /**
         * <p>
         * The authentication standard that is used in the EAP framework. Currently, EAP_TLS is supported.
         * </p>
         * 
         * @param eapMethod
         *        The authentication standard that is used in the EAP framework. Currently, EAP_TLS is supported.
         * @see NetworkEapMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkEapMethod
         */
        Builder eapMethod(NetworkEapMethod eapMethod);

        /**
         * <p>
         * The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager (ACM). This is used to
         * issue certificates to the devices.
         * </p>
         * 
         * @param certificateAuthorityArn
         *        The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager (ACM). This is
         *        used to issue certificates to the devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityArn(String certificateAuthorityArn);
    }

    static final class BuilderImpl implements Builder {
        private String networkProfileArn;

        private String networkProfileName;

        private String description;

        private String ssid;

        private String securityType;

        private String eapMethod;

        private String certificateAuthorityArn;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkProfileData model) {
            networkProfileArn(model.networkProfileArn);
            networkProfileName(model.networkProfileName);
            description(model.description);
            ssid(model.ssid);
            securityType(model.securityType);
            eapMethod(model.eapMethod);
            certificateAuthorityArn(model.certificateAuthorityArn);
        }

        public final String getNetworkProfileArn() {
            return networkProfileArn;
        }

        @Override
        public final Builder networkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
            return this;
        }

        public final void setNetworkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
        }

        public final String getNetworkProfileName() {
            return networkProfileName;
        }

        @Override
        public final Builder networkProfileName(String networkProfileName) {
            this.networkProfileName = networkProfileName;
            return this;
        }

        public final void setNetworkProfileName(String networkProfileName) {
            this.networkProfileName = networkProfileName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSsid() {
            return ssid;
        }

        @Override
        public final Builder ssid(String ssid) {
            this.ssid = ssid;
            return this;
        }

        public final void setSsid(String ssid) {
            this.ssid = ssid;
        }

        public final String getSecurityType() {
            return securityType;
        }

        @Override
        public final Builder securityType(String securityType) {
            this.securityType = securityType;
            return this;
        }

        @Override
        public final Builder securityType(NetworkSecurityType securityType) {
            this.securityType(securityType == null ? null : securityType.toString());
            return this;
        }

        public final void setSecurityType(String securityType) {
            this.securityType = securityType;
        }

        public final String getEapMethod() {
            return eapMethod;
        }

        @Override
        public final Builder eapMethod(String eapMethod) {
            this.eapMethod = eapMethod;
            return this;
        }

        @Override
        public final Builder eapMethod(NetworkEapMethod eapMethod) {
            this.eapMethod(eapMethod == null ? null : eapMethod.toString());
            return this;
        }

        public final void setEapMethod(String eapMethod) {
            this.eapMethod = eapMethod;
        }

        public final String getCertificateAuthorityArn() {
            return certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        @Override
        public NetworkProfileData build() {
            return new NetworkProfileData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
