/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about a device's status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceStatusInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<DeviceStatusInfo.Builder, DeviceStatusInfo> {
    private static final SdkField<List<DeviceStatusDetail>> DEVICE_STATUS_DETAILS_FIELD = SdkField
            .<List<DeviceStatusDetail>> builder(MarshallingType.LIST)
            .memberName("DeviceStatusDetails")
            .getter(getter(DeviceStatusInfo::deviceStatusDetails))
            .setter(setter(Builder::deviceStatusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceStatusDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeviceStatusDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeviceStatusDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONNECTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionStatus").getter(getter(DeviceStatusInfo::connectionStatusAsString))
            .setter(setter(Builder::connectionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatus").build()).build();

    private static final SdkField<Instant> CONNECTION_STATUS_UPDATED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ConnectionStatusUpdatedTime")
            .getter(getter(DeviceStatusInfo::connectionStatusUpdatedTime))
            .setter(setter(Builder::connectionStatusUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatusUpdatedTime")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_STATUS_DETAILS_FIELD,
            CONNECTION_STATUS_FIELD, CONNECTION_STATUS_UPDATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DeviceStatusDetail> deviceStatusDetails;

    private final String connectionStatus;

    private final Instant connectionStatusUpdatedTime;

    private DeviceStatusInfo(BuilderImpl builder) {
        this.deviceStatusDetails = builder.deviceStatusDetails;
        this.connectionStatus = builder.connectionStatus;
        this.connectionStatusUpdatedTime = builder.connectionStatusUpdatedTime;
    }

    /**
     * Returns true if the DeviceStatusDetails property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDeviceStatusDetails() {
        return deviceStatusDetails != null && !(deviceStatusDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more device status detail descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDeviceStatusDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more device status detail descriptions.
     */
    public final List<DeviceStatusDetail> deviceStatusDetails() {
        return deviceStatusDetails;
    }

    /**
     * <p>
     * The latest available information about the connection status of a device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionStatus}
     * will return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionStatusAsString}.
     * </p>
     * 
     * @return The latest available information about the connection status of a device.
     * @see ConnectionStatus
     */
    public final ConnectionStatus connectionStatus() {
        return ConnectionStatus.fromValue(connectionStatus);
    }

    /**
     * <p>
     * The latest available information about the connection status of a device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionStatus}
     * will return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionStatusAsString}.
     * </p>
     * 
     * @return The latest available information about the connection status of a device.
     * @see ConnectionStatus
     */
    public final String connectionStatusAsString() {
        return connectionStatus;
    }

    /**
     * <p>
     * The time (in epoch) when the device connection status changed.
     * </p>
     * 
     * @return The time (in epoch) when the device connection status changed.
     */
    public final Instant connectionStatusUpdatedTime() {
        return connectionStatusUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceStatusDetails() ? deviceStatusDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectionStatusUpdatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceStatusInfo)) {
            return false;
        }
        DeviceStatusInfo other = (DeviceStatusInfo) obj;
        return hasDeviceStatusDetails() == other.hasDeviceStatusDetails()
                && Objects.equals(deviceStatusDetails(), other.deviceStatusDetails())
                && Objects.equals(connectionStatusAsString(), other.connectionStatusAsString())
                && Objects.equals(connectionStatusUpdatedTime(), other.connectionStatusUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceStatusInfo")
                .add("DeviceStatusDetails", hasDeviceStatusDetails() ? deviceStatusDetails() : null)
                .add("ConnectionStatus", connectionStatusAsString())
                .add("ConnectionStatusUpdatedTime", connectionStatusUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceStatusDetails":
            return Optional.ofNullable(clazz.cast(deviceStatusDetails()));
        case "ConnectionStatus":
            return Optional.ofNullable(clazz.cast(connectionStatusAsString()));
        case "ConnectionStatusUpdatedTime":
            return Optional.ofNullable(clazz.cast(connectionStatusUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceStatusInfo, T> g) {
        return obj -> g.apply((DeviceStatusInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceStatusInfo> {
        /**
         * <p>
         * One or more device status detail descriptions.
         * </p>
         * 
         * @param deviceStatusDetails
         *        One or more device status detail descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceStatusDetails(Collection<DeviceStatusDetail> deviceStatusDetails);

        /**
         * <p>
         * One or more device status detail descriptions.
         * </p>
         * 
         * @param deviceStatusDetails
         *        One or more device status detail descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceStatusDetails(DeviceStatusDetail... deviceStatusDetails);

        /**
         * <p>
         * One or more device status detail descriptions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeviceStatusDetail>.Builder} avoiding the
         * need to create one manually via {@link List<DeviceStatusDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeviceStatusDetail>.Builder#build()} is called immediately
         * and its result is passed to {@link #deviceStatusDetails(List<DeviceStatusDetail>)}.
         * 
         * @param deviceStatusDetails
         *        a consumer that will call methods on {@link List<DeviceStatusDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceStatusDetails(List<DeviceStatusDetail>)
         */
        Builder deviceStatusDetails(Consumer<DeviceStatusDetail.Builder>... deviceStatusDetails);

        /**
         * <p>
         * The latest available information about the connection status of a device.
         * </p>
         * 
         * @param connectionStatus
         *        The latest available information about the connection status of a device.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder connectionStatus(String connectionStatus);

        /**
         * <p>
         * The latest available information about the connection status of a device.
         * </p>
         * 
         * @param connectionStatus
         *        The latest available information about the connection status of a device.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder connectionStatus(ConnectionStatus connectionStatus);

        /**
         * <p>
         * The time (in epoch) when the device connection status changed.
         * </p>
         * 
         * @param connectionStatusUpdatedTime
         *        The time (in epoch) when the device connection status changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionStatusUpdatedTime(Instant connectionStatusUpdatedTime);
    }

    static final class BuilderImpl implements Builder {
        private List<DeviceStatusDetail> deviceStatusDetails = DefaultSdkAutoConstructList.getInstance();

        private String connectionStatus;

        private Instant connectionStatusUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceStatusInfo model) {
            deviceStatusDetails(model.deviceStatusDetails);
            connectionStatus(model.connectionStatus);
            connectionStatusUpdatedTime(model.connectionStatusUpdatedTime);
        }

        public final Collection<DeviceStatusDetail.Builder> getDeviceStatusDetails() {
            if (deviceStatusDetails instanceof SdkAutoConstructList) {
                return null;
            }
            return deviceStatusDetails != null ? deviceStatusDetails.stream().map(DeviceStatusDetail::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deviceStatusDetails(Collection<DeviceStatusDetail> deviceStatusDetails) {
            this.deviceStatusDetails = DeviceStatusDetailsCopier.copy(deviceStatusDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceStatusDetails(DeviceStatusDetail... deviceStatusDetails) {
            deviceStatusDetails(Arrays.asList(deviceStatusDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceStatusDetails(Consumer<DeviceStatusDetail.Builder>... deviceStatusDetails) {
            deviceStatusDetails(Stream.of(deviceStatusDetails).map(c -> DeviceStatusDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDeviceStatusDetails(Collection<DeviceStatusDetail.BuilderImpl> deviceStatusDetails) {
            this.deviceStatusDetails = DeviceStatusDetailsCopier.copyFromBuilder(deviceStatusDetails);
        }

        public final String getConnectionStatus() {
            return connectionStatus;
        }

        @Override
        public final Builder connectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        @Override
        public final Builder connectionStatus(ConnectionStatus connectionStatus) {
            this.connectionStatus(connectionStatus == null ? null : connectionStatus.toString());
            return this;
        }

        public final void setConnectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
        }

        public final Instant getConnectionStatusUpdatedTime() {
            return connectionStatusUpdatedTime;
        }

        @Override
        public final Builder connectionStatusUpdatedTime(Instant connectionStatusUpdatedTime) {
            this.connectionStatusUpdatedTime = connectionStatusUpdatedTime;
            return this;
        }

        public final void setConnectionStatusUpdatedTime(Instant connectionStatusUpdatedTime) {
            this.connectionStatusUpdatedTime = connectionStatusUpdatedTime;
        }

        @Override
        public DeviceStatusInfo build() {
            return new DeviceStatusInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
